package io.privy.auth

import kotlinx.coroutines.sync.Mutex
import kotlinx.coroutines.sync.withLock
import kotlinx.coroutines.yield

internal class PrivyReadyStateManager {
  private var isPrivyReady = false

  // Use a mutex to ensure thread-safe access
  private val mutex = Mutex()

  suspend fun setReady(ready: Boolean) {
    mutex.withLock { // Lock for exclusive access
      isPrivyReady = ready
    }
  }

  suspend fun awaitReady() {
    // Use a while loop with yield() to avoid busy waiting
    while (!isPrivyReady) {
      yield() // Allow other coroutines to run
    }
  }
}