package io.privy.auth

import io.privy.auth.customAuth.LoginWithCustomAuth
import io.privy.auth.customAuth.RealLoginWithCustomAuth
import io.privy.auth.email.LoginWithEmail
import io.privy.auth.email.RealLoginWithEmail
import io.privy.auth.internal.InternalAuthManager
import io.privy.auth.internal.InternalAuthStateRepository
import io.privy.auth.internal.InternalInternalAuthStateRepository
import io.privy.auth.internal.RealAuthRepository
import io.privy.auth.internal.RealInternalAuthManager
import io.privy.auth.internal.RealInternalAuthStateRepository
import io.privy.auth.jwt.DecodeJwt
import io.privy.auth.jwt.RealDecodeJwt
import io.privy.auth.oAuth.LoginWithOAuth
import io.privy.auth.oAuth.RealLoginWithOAuth
import io.privy.auth.persistence.AuthSessionDataStore
import io.privy.auth.persistence.DataStoreBindings
import io.privy.auth.persistence.RealAuthSessionDataStore
import io.privy.auth.session.AuthSessionResponseDeserializer
import io.privy.auth.session.RealAuthSessionResponseDeserializer
import io.privy.auth.session.internal.InternalAuthSessionSerializer
import io.privy.auth.session.internal.MapRawAuthSessionResponseToAuthSessionResponse
import io.privy.auth.session.internal.RealInternalAuthSessionSerializer
import io.privy.auth.session.internal.RealMapRawAuthSessionResponseToAuthSessionResponse
import io.privy.auth.siwe.LoginWithSiwe
import io.privy.auth.siwe.RealLoginWithSiwe
import io.privy.auth.sms.LoginWithSms
import io.privy.auth.sms.RealLoginWithSms
import io.privy.di.KmpAppScope
import me.tatarka.inject.annotations.Provides

public interface AuthBindings : DataStoreBindings {
  public val auth: PrivyAuth

  @Provides public fun RealPrivyAuth.bind(): PrivyAuth = this

  @Provides public fun RealAuthRepository.bind(): AuthRepository = this

  @Provides public fun RealLoginWithSms.bind(): LoginWithSms = this

  @Provides public fun RealLoginWithEmail.bind(): LoginWithEmail = this

  @Provides public fun RealLoginWithCustomAuth.bind(): LoginWithCustomAuth = this

  @Provides public fun RealLoginWithSiwe.bind(): LoginWithSiwe = this

  @Provides public fun RealLoginWithOAuth.bind(): LoginWithOAuth = this

  @Provides
  public fun internalAuthStateRepository(
      real: RealInternalAuthStateRepository
  ): InternalInternalAuthStateRepository = real

  @Provides
  public fun authStateRepository(real: RealInternalAuthStateRepository): InternalAuthStateRepository = real

  @Provides public fun authRefreshService(real: RealAuthRefreshService): AuthRefreshService = real

  @KmpAppScope @Provides public fun RealInternalAuthManager.bind(): InternalAuthManager = this

  @Provides
  public fun RealAuthSessionResponseDeserializer.bind(): AuthSessionResponseDeserializer = this

  @Provides
  public fun RealInternalAuthSessionSerializer.bind(): InternalAuthSessionSerializer = this

  @Provides
  public fun RealMapRawAuthSessionResponseToAuthSessionResponse.bind():
      MapRawAuthSessionResponseToAuthSessionResponse = this

  @Provides public fun RealDecodeJwt.bind(): DecodeJwt = this

  @Provides public fun RealPrivyUser.bind(): PrivyUser = this

  @KmpAppScope @Provides public fun RealAuthSessionDataStore.bind(): AuthSessionDataStore = this
}
