package io.privy.auth

import io.privy.auth.internal.InternalPrivyUser
import io.privy.auth.siwe.InternalSiweMessage
import io.privy.auth.internal.LoginMethod
import io.privy.auth.oAuth.OAuthInitRequest
import io.privy.auth.oAuth.OAuthInitResponse
import io.privy.auth.otp.OtpRequestType
import io.privy.auth.session.internal.AuthSessionResponse
import io.privy.network.ApiResult

public interface AuthRepository {
  public suspend fun authenticate(loginType: LoginType): ApiResult<AuthSessionResponse>

  public suspend fun refreshSession(
      authToken: String,
      refreshToken: String,
      currentLoginMethod: LoginMethod,
  ): ApiResult<AuthSessionResponse>

  public suspend fun refreshUser(authToken: String): ApiResult<InternalPrivyUser>

  /**
   * Sends OTP to the requested destination
   *
   * @param otpRequestType Either email or SMS
   * @return Result type with no associated value representing if OTP was sent successfully or not
   */
  public suspend fun sendOtp(otpRequestType: OtpRequestType): ApiResult<Unit>

  public suspend fun link(loginType: LoginType, authToken: String): ApiResult<InternalPrivyUser>

  public suspend fun update(accountType: UpdateAccountType, authToken: String): ApiResult<InternalPrivyUser>

  /**
   * Generates a SIWE (Sign-In with Ethereum) message for the given wallet address.
   *
   * @param walletAddress The Ethereum wallet address for which to generate the SIWE message
   * @return Result.success with a GenerateSiweMessageResponse containing the nonce and other
   *   details needed to construct the SIWE message, or Result.failure if the generation fails
   */
  public suspend fun generateSiweMessage(walletAddress: String): ApiResult<InternalSiweMessage>

    public suspend fun generateOAuthUrl(
        oAuthInitRequest: OAuthInitRequest
    ): ApiResult<OAuthInitResponse>
}


