package io.privy.auth

import io.privy.auth.oAuth.OAuthProvider
import io.privy.auth.passkey.PasskeyAuthenticationResponse
import io.privy.auth.passkey.PasskeyRegistrationResponse
import io.privy.auth.siwe.SiweLoginParams

public sealed interface LoginType {
  public data class CustomAccessToken(val token: String) : LoginType

  public data class Sms(val phoneNumber: String, val code: String) : LoginType

  public data class Email(val emailAddress: String, val code: String) : LoginType

  public data class Siwe(val params: SiweLoginParams) : LoginType

  public data class OAuth(
    val provider: OAuthProvider,
    val authorizationCode: String,
    val codeVerifier: String,
    val stateCode: String
  ) : LoginType

  public data class PasskeyRegistration(
    val credential: PasskeyRegistrationResponse,
    val relyingParty: String,
  ) : LoginType

  public data class PasskeyAuthentication(
    val credential: PasskeyAuthenticationResponse,
    val challenge: String,
    val relyingParty: String,
  ) : LoginType
}


