package io.privy.auth.passkey

/**
 * Manager for platform-specific passkey operations.
 *
 * This interface abstracts passkey credential operations across different platforms.
 * On Android, this uses the Credential Manager API. On iOS, this would use
 * ASAuthorizationController (not yet implemented).
 */
public interface PasskeyManager {
  /**
   * Creates a new passkey credential.
   *
   * This method triggers the platform's passkey creation flow, which typically
   * involves user authentication via biometrics or device PIN.
   *
   * @param options The registration options received from the server containing
   *                challenge, relying party info, user info, and other parameters
   * @return Result containing the credential response to send back to the server,
   *         or an error if creation failed
   */
  public suspend fun createPasskey(options: RegistrationOptions): Result<PasskeyRegistrationResponse>

  /**
   * Retrieves an existing passkey credential for authentication.
   *
   * This method shows the platform's passkey selector and prompts for user
   * verification via biometrics or device PIN.
   *
   * @param options The authentication options received from the server containing
   *                challenge, relying party ID, and other parameters
   * @return Result containing the credential assertion to send back to the server,
   *         or an error if authentication failed
   */
  public suspend fun getPasskey(options: AuthenticationOptions): Result<PasskeyAuthenticationResponse>
}

