package io.privy.auth.internal

public sealed interface InternalAuthState {
  public data object NotReady : InternalAuthState

  public data object Unauthenticated : InternalAuthState

  // User is authenticated and has a valid auth session
  public data class Authenticated(val session: InternalAuthSession) : InternalAuthState

  public fun isAuthenticated(): Boolean {
    return this is Authenticated
  }
}