package io.privy.auth.sms

import io.privy.auth.PrivyUser

public interface LoginWithSms {
  /**
   * Sends an OTP to the user via SMS.
   *
   * @param phoneNumber The phone number to send the OTP to.
   * @return Result type with no associated value representing if OTP was sent successfully or not
   */
  public suspend fun sendCode(phoneNumber: String): Result<Unit>

  /**
   * Logs the user in.
   *
   * @param code The OTP sent to the user.
   * @param phoneNumber Phone number the OTP was sent to. If omitted, the phone number from
   *   "sendCode" will be used.
   * @return A Result type with the PrivyUser object if login attempt was successful, or a
   *   Result.failure otherwise.
   */
  public suspend fun loginWithCode(code: String, phoneNumber: String? = null): Result<PrivyUser>
}
