package io.privy.auth

// An extension on Result<T> that "flat maps" or "flattens" a result type on success.
// Use this if you want to internally call a function that returns a result type within the
// onSuccess block of another Result type
public inline fun <T, R> Result<T>.flatMap(transform: (value: T) -> Result<R>): Result<R> {
  return this.fold(onSuccess = transform, onFailure = { Result.failure(it) })
}
