package io.privy.auth.oAuth

/**
 * Interface defining the OAuth authentication flow handling capabilities.
 * Implementations of this interface are responsible for managing the OAuth
 * authentication process, including initiating login flows and handling redirect URLs.
 */
public interface OAuthHandler {
    /**
     * Opens the URL in a Chrome Custom Tab.
     *
     * @param authUrl The authentication URL to open
     *
     * @return Result indicating success or failure of launching the chrome tab
     */
    public fun launchCustomTab(authUrl: String)

}