package io.privy.auth.oAuth

import io.privy.auth.PrivyUser

/**
 * Interface for authenticating users via OAuth providers. This interface provides a simplified API
 * for applications to implement OAuth-based authentication flows with various providers like
 * Google, Apple, etc.
 */
public interface LoginWithOAuth {
  /**
   * Initiates the OAuth login flow with the specified provider by launching the provider's
   * authentication page in a chrome tab. After the authentication is complete, the chrome tab will
   * redirect back to your app using the "appUrlScheme" provided. This will trigger your Activity's
   * "onNewIntent" or "onCreate", depending on the "android:launchMode" set in your Manifest. Once
   * you receive the intent from the redirect, grab the "intent.dataString", and pass it to Privy
   * via [handleIntentData]. If Privy can handle the redirect, we will authenticate the user and
   * return the result.
   *
   * @param oAuthProvider The OAuth provider to authenticate with (e.g., Google, Twitter, Discord)
   * @param appUrlScheme The URL scheme registered for the app to handle redirects
   * @return Result containing the authenticated PrivyUser on success, or an exception on failure
   */
  public suspend fun login(oAuthProvider: OAuthProvider, appUrlScheme: String): Result<PrivyUser>
}
