package io.privy.auth.siws

/** Parameters for generating a SIWS (Sign-In With Solana) message. */
public data class SiwsMessageParams(
    /// The app's domain, e.g. "my-domain.com"
    val appDomain: String,

    /// The app's uri, e.g. "https://my-domain.com"
    val appUri: String,

    /// The Solana wallet's address being used to sign in
    val walletAddress: String
)
