package io.privy.auth.passkey

/**
 * Platform-specific handler for passkey credential operations.
 *
 * This interface abstracts the platform's native passkey/credential APIs.
 * It operates on raw JSON strings to avoid exposing platform-specific types
 * in the public API.
 *
 * - Android: Uses Credential Manager API
 * - iOS: Would use ASAuthorizationController (not yet implemented)
 */
public interface PasskeyHandler {
  /**
   * Creates a new passkey credential.
   *
   * @param registrationOptions JSON string containing WebAuthn PublicKeyCredentialCreationOptions
   *                           in camelCase format (for Android Credential Manager)
   * @return Result containing JSON string with the credential response, or an error if creation failed
   */
  public suspend fun createCredential(registrationOptions: String): Result<String>

  /**
   * Retrieves an existing passkey credential for authentication.
   *
   * @param authenticationOptions JSON string containing WebAuthn PublicKeyCredentialRequestOptions
   *                             in camelCase format (for Android Credential Manager)
   * @return Result containing JSON string with the credential assertion, or an error if retrieval failed
   */
  public suspend fun getCredential(authenticationOptions: String): Result<String>
}
