package io.privy.auth

public sealed interface LinkedAccount {
  public data class CustomAuth(
    val customUserId: String,
    val firstVerifiedAt: Int?,
    val latestVerifiedAt: Int?
  ) : LinkedAccount

  public sealed interface EmbeddedWalletAccount: LinkedAccount {
    public val address: String
    public val chainId: String?
    public val recoveryMethod: String?
    public val hdWalletIndex: Int
  }

  public data class EmbeddedEthereumWalletAccount(
    override val address: String,
    override val chainId: String?,
    override val recoveryMethod: String?,
    override val hdWalletIndex: Int
  ) : EmbeddedWalletAccount

  public data class EmbeddedSolanaWalletAccount(
    override val address: String,
    override val chainId: String?,
    override val recoveryMethod: String?,
    override val hdWalletIndex: Int
  ) : EmbeddedWalletAccount

  public data class PhoneAccount(
    val phoneNumber: String
  ): LinkedAccount

  public data class EmailAccount(
    val emailAddress: String
  ): LinkedAccount
}

// Ethereum Embedded wallet with hdWalletIndex == 0 is the primary wallet
public fun List<LinkedAccount>.primaryEmbeddedEthereumWalletAccountOrNull(): LinkedAccount.EmbeddedEthereumWalletAccount? {
  return this.filterIsInstance<LinkedAccount.EmbeddedEthereumWalletAccount>()
    .firstOrNull { it.hdWalletIndex == 0 }
}

// Solana embedded wallet with hdWalletIndex == 0 is the primary wallet
public fun List<LinkedAccount>.primaryEmbeddedSolanaWalletAccountOrNull(): LinkedAccount.EmbeddedSolanaWalletAccount? {
  return this.filterIsInstance<LinkedAccount.EmbeddedSolanaWalletAccount>()
    .firstOrNull { it.hdWalletIndex == 0 }
}