package io.privy.auth

import io.privy.wallet.ethereum.EmbeddedEthereumWallet
import io.privy.wallet.solana.EmbeddedSolanaWallet

public interface PrivyUser {
  public val id: String
  public val linkedAccounts: List<LinkedAccount>
  public val embeddedEthereumWallets: List<EmbeddedEthereumWallet>
  public val embeddedSolanaWallets: List<EmbeddedSolanaWallet>

  public suspend fun createEthereumWallet(allowAdditional: Boolean = false):  Result<EmbeddedEthereumWallet>

  public suspend fun createSolanaWallet(): Result<EmbeddedSolanaWallet>

  public suspend fun refresh()
}
