package io.privy.auth

import kotlin.jvm.JvmInline

public sealed interface AuthState {
  // AuthState has not been determined yet, show loading
  public data object NotReady : AuthState

  // User is unauthenticated
  public data object Unauthenticated : AuthState

  // User is authenticated and has a valid auth session
  @JvmInline public value class Authenticated(public val user: PrivyUser) : AuthState

  public fun isAuthenticated(): Boolean {
    return this is Authenticated
  }

  /**
   * Extension function on auth state that specifies if the user's auth state has been determined.
   * The user's auth state is considered determined when it's set to something other than "NotReady".
   */
  public fun hasBeenDetermined(): Boolean {
    return this !is NotReady
  }
}
