package io.privy.auth.email

import io.privy.auth.PrivyUser

public interface LoginWithEmail {
  /**
   * Sends an OTP to the user via email.
   *
   * @param email The phone number to send the OTP to.
   * @return Result type with no associated value representing if OTP was sent successfully or not
   */
  public suspend fun sendCode(email: String): Result<Unit>

  /**
   * Logs the user in.
   *
   * @param code The OTP sent to the user.
   * @param email Email address the OTP was sent to. If omitted, the email from "sendCode" will be
   *   used.
   * @return A Result type with the PrivyUser object if login attempt was successful, or a
   *   Result.failure otherwise.
   */
  public suspend fun loginWithCode(code: String, email: String? = null): Result<PrivyUser>

  /**
   * Links an email account to an existing user.
   *
   * @param code The OTP sent to the user.
   * @param email Email address the OTP was sent to. If omitted, the email from "sendCode" will be
   *   used.
   * @return A Result type with no associated value representing if the account was linked
   *   successfully, or a Result.failure otherwise.
   */
  public suspend fun linkWithCode(code: String, email: String? = null): Result<Unit>
}
