package io.privy.di

import android.content.Context
import io.privy.logging.PrivyLogLevel
import io.privy.network.PrivyEnvironment
import io.privy.wallet.webview.WebViewHandler
import me.tatarka.inject.annotations.Component
import me.tatarka.inject.annotations.Provides

@KmpAppScope
@Component
public abstract class KmpAppComponent(
    @get:Provides protected val context: Context,
    @get:Provides public val privyAppId: PrivyAppId,
    @get:Provides public val privyAppClientId: PrivyAppClientId,
    @get:Provides public val privyLogLevel: PrivyLogLevel,
    @get:Provides public val appBundleIdentifier: AppBundleIdentifier,
    @get:Provides public val webViewHandler: WebViewHandler,
    @get:Provides public val privyEnvironment: PrivyEnvironment,
) : KmpAppComponentBindings {
  public companion object {
    public fun create(
        context: Context,
        privyAppId: String,
        privyAppClientId: String,
        privyLogLevel: PrivyLogLevel,
        appBundleIdentifier: String,
        webViewHandler: WebViewHandler,
        privyEnvironment: PrivyEnvironment,
    ): KmpAppComponent =
        KmpAppComponent::class.create(
            context,
            privyAppId,
            privyAppClientId,
            privyLogLevel,
            appBundleIdentifier,
            webViewHandler,
            privyEnvironment,
        )
  }
}
