package io.privy.di

import android.content.Context
import io.privy.auth.oAuth.OAuthHandler
import io.privy.auth.oAuth.PKCEHelper
import io.privy.logging.PrivyLogLevel
import io.privy.network.NetworkStateManager
import io.privy.network.PrivyEnvironment
import io.privy.network.PrivyInternalSettings
import io.privy.wallet.webview.WebViewHandler
import me.tatarka.inject.annotations.Component
import me.tatarka.inject.annotations.Provides

@KmpAppScope
@Component
public abstract class KmpAppComponent(
    @get:Provides protected val context: Context,
    @get:Provides public val privyAppId: PrivyAppId,
    @get:Provides public val privyAppClientId: PrivyAppClientId,
    @get:Provides public val privyLogLevel: PrivyLogLevel,
    @get:Provides public val appBundleIdentifier: AppBundleIdentifier,
    @get:Provides public val webViewHandler: WebViewHandler,
    @get:Provides public val privyEnvironment: PrivyEnvironment,
    @get:Provides public val privyInternalSettings: PrivyInternalSettings?,
    @get:Provides public val networkStateManager: NetworkStateManager,
    @get:Provides public val pkceHelper: PKCEHelper,
    @get:Provides public val oAuthHandler: OAuthHandler
) : KmpAppComponentBindings {
  public companion object {
    public fun create(
        context: Context,
        privyAppId: String,
        privyAppClientId: String,
        privyLogLevel: PrivyLogLevel,
        appBundleIdentifier: String,
        webViewHandler: WebViewHandler,
        privyEnvironment: PrivyEnvironment,
        privyInternalSettings: PrivyInternalSettings?,
        networkStateManager: NetworkStateManager,
        pkceHelper: PKCEHelper,
        oAuthHandler: OAuthHandler,
    ): KmpAppComponent =
        KmpAppComponent::class.create(
            context,
            privyAppId,
            privyAppClientId,
            privyLogLevel,
            appBundleIdentifier,
            webViewHandler,
            privyEnvironment,
            privyInternalSettings,
            networkStateManager,
            pkceHelper,
            oAuthHandler,
            )
  }
}
