package io.privy.di

import android.content.Context
import io.privy.analytics.AnalyticsManager
import io.privy.analytics.ClientAnalyticsIdRepository
import io.privy.analytics.RealAnalyticsManager
import io.privy.analytics.RealAnalyticsRepository
import io.privy.analytics.RealClientAnalyticsIdRepository
import io.privy.analytics.persistence.RealClientAnalyticsIdDataStore
import io.privy.auth.AuthManager
import io.privy.auth.AuthRepository
import io.privy.auth.AuthStateRepository
import io.privy.auth.RealAuthManager
import io.privy.auth.RealAuthRefreshService
import io.privy.auth.RealAuthRepository
import io.privy.auth.RealAuthStateRepository
import io.privy.auth.RealPrivyUser
import io.privy.auth.customAuth.LoginWithCustomAuth
import io.privy.auth.customAuth.RealLoginWithCustomAuth
import io.privy.auth.email.LoginWithEmail
import io.privy.auth.email.RealLoginWithEmail
import io.privy.auth.jwt.RealDecodeJwt
import io.privy.auth.oAuth.LoginWithOAuth
import io.privy.auth.oAuth.OAuthHandler
import io.privy.auth.oAuth.PKCEHelper
import io.privy.auth.oAuth.RealLoginWithOAuth
import io.privy.auth.persistence.RealAuthSessionDataStore
import io.privy.auth.session.RealAuthSessionResponseDeserializer
import io.privy.auth.session.`internal`.RealInternalAuthSessionSerializer
import io.privy.auth.session.`internal`.RealMapRawAuthSessionResponseToAuthSessionResponse
import io.privy.auth.siwe.LoginWithSiwe
import io.privy.auth.siwe.RealLoginWithSiwe
import io.privy.auth.sms.LoginWithSms
import io.privy.auth.sms.RealLoginWithSms
import io.privy.logging.PrivyLogLevel
import io.privy.logging.PrivyLogger
import io.privy.logging.RealPrivyLogger
import io.privy.network.KtorWrapper
import io.privy.network.NetworkStateManager
import io.privy.network.PrivyEnvironment
import io.privy.network.PrivyInternalSettings
import io.privy.wallet.EmbeddedWalletManager
import io.privy.wallet.RealEmbeddedWalletManager
import io.privy.wallet.ethereum.RealEmbeddedEthereumWallet
import io.privy.wallet.ethereum.RealEmbeddedEthereumWalletFactory
import io.privy.wallet.ethereum.RealEmbeddedEthereumWalletProvider
import io.privy.wallet.solana.RealEmbeddedSolanaWallet
import io.privy.wallet.solana.RealEmbeddedSolanaWalletFactory
import io.privy.wallet.solana.RealEmbeddedSolanaWalletProvider
import io.privy.wallet.webview.WebViewHandler
import kotlin.reflect.KClass
import me.tatarka.inject.`internal`.LazyMap
import me.tatarka.inject.`internal`.ScopedComponent

public fun KClass<KmpAppComponent>.create(
  context: Context,
  privyAppId: PrivyAppId,
  privyAppClientId: PrivyAppClientId,
  privyLogLevel: PrivyLogLevel,
  appBundleIdentifier: AppBundleIdentifier,
  webViewHandler: WebViewHandler,
  privyEnvironment: PrivyEnvironment,
  privyInternalSettings: PrivyInternalSettings?,
  networkStateManager: NetworkStateManager,
  pkceHelper: PKCEHelper,
  oAuthHandler: OAuthHandler,
): KmpAppComponent = InjectKmpAppComponent(context, privyAppId, privyAppClientId, privyLogLevel,
    appBundleIdentifier, webViewHandler, privyEnvironment, privyInternalSettings,
    networkStateManager, pkceHelper, oAuthHandler)

public class InjectKmpAppComponent(
  context: Context,
  privyAppId: PrivyAppId,
  privyAppClientId: PrivyAppClientId,
  privyLogLevel: PrivyLogLevel,
  appBundleIdentifier: AppBundleIdentifier,
  webViewHandler: WebViewHandler,
  privyEnvironment: PrivyEnvironment,
  privyInternalSettings: PrivyInternalSettings?,
  networkStateManager: NetworkStateManager,
  pkceHelper: PKCEHelper,
  oAuthHandler: OAuthHandler,
) : KmpAppComponent(context, privyAppId, privyAppClientId, privyLogLevel, appBundleIdentifier,
    webViewHandler, privyEnvironment, privyInternalSettings, networkStateManager, pkceHelper,
    oAuthHandler), ScopedComponent {
  override val _scoped: LazyMap = LazyMap()

  private val ktorWrapper: KtorWrapper
    get() = KtorWrapper(
      privyInternalSettings = privyInternalSettings,
      ktorProvider = _scoped.get("io.privy.network.KtorProvider") {
        provideKtorProvider(
          privyEnvironment = privyEnvironment,
          logger = privyLogger,
          privyAppId = privyAppId,
          privyAppClientId = privyAppClientId,
          appBundleIdentifier = appBundleIdentifier
        )
      },
      clientAnalyticsIdRepository = clientAnalyticsIdRepository,
      networkStateManager = networkStateManager
    )

  private val privyLogger: PrivyLogger
    get() = RealPrivyLogger(
      level = privyLogLevel,
      appId = privyAppId
    ).bind()

  private val realAuthStateRepository: RealAuthStateRepository
    get() = _scoped.get("io.privy.auth.RealAuthStateRepository") {
      RealAuthStateRepository(
        authSessionDataStore = _scoped.get("io.privy.auth.persistence.AuthSessionDataStore") {
          _scoped.get("io.privy.auth.persistence.RealAuthSessionDataStore") {
            RealAuthSessionDataStore(
              authSessionDataStoreHolder =
                  _scoped.get("io.privy.auth.persistence.AuthSessionDataStoreHolder") {
                providePreferencesDataStore(
                  context = context
                )
              },
              authSessionSerializer = RealInternalAuthSessionSerializer().bind()
            )
          }.bind()
        }
      )
    }

  private val embeddedWalletManager: EmbeddedWalletManager
    get() = _scoped.get("io.privy.wallet.EmbeddedWalletManager") {
      RealEmbeddedWalletManager(
        webViewHandler = webViewHandler,
        privyLogger = privyLogger,
        authStateRepository = authStateRepository
      ).bind()
    }

  override val authManager: AuthManager
    get() = _scoped.get("io.privy.auth.AuthManager") {
      RealAuthManager(
        authRepository = authRepository,
        authStateRepository = internalAuthStateRepository(
          real = realAuthStateRepository
        ),
        privyLogger = privyLogger,
        decodeJwt = RealDecodeJwt().bind(),
        authRefreshService = authRefreshService(
          real = _scoped.get("io.privy.auth.RealAuthRefreshService") {
            RealAuthRefreshService(
              authRepository = authRepository
            )
          }
        ),
        networkStateManager = networkStateManager,
        privyUserCreator = { arg0 ->
          RealPrivyUser(
            authManager = arg0,
            embeddedEthereumWalletFactory = RealEmbeddedEthereumWalletFactory(
              embeddedEthereumWalletCreator = { arg0_ ->
                RealEmbeddedEthereumWallet(
                  embeddedWalletDetails = arg0_,
                  embeddedEthereumWalletProviderCreator = { arg0__ ->
                    RealEmbeddedEthereumWalletProvider(
                      embeddedWalletDetails = arg0__,
                      embeddedWalletManager = embeddedWalletManager,
                      privyLogger = privyLogger
                    ).bind()
                  }
                ).bind()
              }
            ).bind(),
            embeddedSolanaWalletFactory = RealEmbeddedSolanaWalletFactory(
              embeddedSolanaWalletCreator = { arg0_ ->
                RealEmbeddedSolanaWallet(
                  embeddedWalletDetails = arg0_,
                  rpcProviderCreator = { arg0__ ->
                    RealEmbeddedSolanaWalletProvider(
                      embeddedWalletDetails = arg0__,
                      embeddedWalletManager = embeddedWalletManager,
                      privyLogger = privyLogger
                    ).bind()
                  }
                ).bind()
              }
            ).bind(),
            embeddedWalletManager = embeddedWalletManager,
            privyLogger = privyLogger
          ).bind()
        }
      ).bind()
    }

  override val authRepository: AuthRepository
    get() = RealAuthRepository(
      ktorWrapper = ktorWrapper,
      privyLogger = privyLogger,
      authSessionResponseDeserializer = RealAuthSessionResponseDeserializer().bind(),
      mapRawAuthSessionResponseToAuthSessionResponse =
          RealMapRawAuthSessionResponseToAuthSessionResponse(
        logger = privyLogger
      ).bind()
    ).bind()

  override val authStateRepository: AuthStateRepository
    get() = authStateRepository(
      real = realAuthStateRepository
    )

  override val loginWithCustomAuth: LoginWithCustomAuth
    get() = RealLoginWithCustomAuth(
      authManager = authManager
    ).bind()

  override val loginWithEmail: LoginWithEmail
    get() = RealLoginWithEmail(
      authManager = authManager
    ).bind()

  override val loginWithOAuth: LoginWithOAuth
    get() = RealLoginWithOAuth(
      oAuthHandler = oAuthHandler,
      pkceHelper = pkceHelper,
      authManager = authManager,
      logger = privyLogger
    ).bind()

  override val loginWithSiwe: LoginWithSiwe
    get() = RealLoginWithSiwe(
      authManager = authManager
    ).bind()

  override val loginWithSms: LoginWithSms
    get() = RealLoginWithSms(
      authManager = authManager
    ).bind()

  override val analyticsManager: AnalyticsManager
    get() = _scoped.get("io.privy.analytics.AnalyticsManager") {
      RealAnalyticsManager(
        analyticsRepository = RealAnalyticsRepository(
          ktorWrapper = ktorWrapper,
          privyLogger = privyLogger,
          clientAnalyticsIdRepository = clientAnalyticsIdRepository
        ).bind()
      ).bind()
    }

  override val clientAnalyticsIdRepository: ClientAnalyticsIdRepository
    get() = _scoped.get("io.privy.analytics.ClientAnalyticsIdRepository") {
      RealClientAnalyticsIdRepository(
        clientAnalyticsIdDataStore =
            _scoped.get("io.privy.analytics.persistence.RealClientAnalyticsIdDataStore") {
          RealClientAnalyticsIdDataStore(
            clientAnalyticsIdDataStoreHolder =
                _scoped.get("io.privy.analytics.persistence.ClientAnalyticsIdDataStoreHolder") {
              provideClientAnalyticsIdDataStore(
                context = context
              )
            }
          )
        }.bind()
      ).bind()
    }
}
