package io.privy.di

import android.content.Context
import io.privy.analytics.AnalyticsManager
import io.privy.analytics.ClientAnalyticsIdRepository
import io.privy.analytics.RealAnalyticsManager
import io.privy.analytics.RealAnalyticsRepository
import io.privy.analytics.RealClientAnalyticsIdRepository
import io.privy.analytics.persistence.RealClientAnalyticsIdDataStore
import io.privy.appconfig.AppConfigRepository
import io.privy.appconfig.RealAppConfigRepository
import io.privy.auth.AuthRefreshService
import io.privy.auth.AuthRepository
import io.privy.auth.PrivyAuth
import io.privy.auth.RealAuthRefreshService
import io.privy.auth.RealPrivyAuth
import io.privy.auth.RealPrivyUser
import io.privy.auth.`internal`.InternalAuthStateRepository
import io.privy.auth.`internal`.InternalInternalAuthStateRepository
import io.privy.auth.`internal`.RealAuthRepository
import io.privy.auth.`internal`.RealInternalAuthManager
import io.privy.auth.`internal`.RealInternalAuthStateRepository
import io.privy.auth.customAuth.RealLoginWithCustomAuth
import io.privy.auth.email.RealLoginWithEmail
import io.privy.auth.jwt.DecodeJwt
import io.privy.auth.jwt.RealDecodeJwt
import io.privy.auth.oAuth.OAuthHandler
import io.privy.auth.oAuth.PKCEHelper
import io.privy.auth.oAuth.RealLoginWithOAuth
import io.privy.auth.persistence.RealAuthSessionDataStore
import io.privy.auth.session.RealAuthSessionResponseDeserializer
import io.privy.auth.session.`internal`.RealInternalAuthSessionSerializer
import io.privy.auth.session.`internal`.RealMapRawAuthSessionResponseToAuthSessionResponse
import io.privy.auth.siwe.RealLoginWithSiwe
import io.privy.auth.sms.RealLoginWithSms
import io.privy.logging.PrivyLogLevel
import io.privy.logging.PrivyLogger
import io.privy.logging.RealPrivyLogger
import io.privy.network.KtorWrapper
import io.privy.network.NetworkStateManager
import io.privy.network.PrivyEnvironment
import io.privy.network.PrivyInternalSettings
import io.privy.wallet.EmbeddedWalletRepository
import io.privy.wallet.RealEmbeddedWalletManager
import io.privy.wallet.RealEmbeddedWalletRepository
import io.privy.wallet.creation.RealWalletApiWalletCreator
import io.privy.wallet.creation.RealWalletCreatorFactory
import io.privy.wallet.creation.RealWebViewWalletCreator
import io.privy.wallet.creation.WalletCreator
import io.privy.wallet.ethereum.RealEmbeddedEthereumWallet
import io.privy.wallet.ethereum.RealEmbeddedEthereumWalletFactory
import io.privy.wallet.ethereum.RealEmbeddedEthereumWalletProvider
import io.privy.wallet.rpc.RealWalletApiRpcExecutor
import io.privy.wallet.rpc.RealWalletRpcExecutorFactory
import io.privy.wallet.rpc.WalletRpcExecutor
import io.privy.wallet.solana.RealEmbeddedSolanaWallet
import io.privy.wallet.solana.RealEmbeddedSolanaWalletFactory
import io.privy.wallet.solana.RealEmbeddedSolanaWalletProvider
import io.privy.wallet.walletApi.JsonCanonicalizer
import io.privy.wallet.walletApi.RealJsonCanonicalizer
import io.privy.wallet.walletApi.RealWalletApiRepository
import io.privy.wallet.webview.RealUserSigner
import io.privy.wallet.webview.RealWebViewWalletConnector
import io.privy.wallet.webview.RealWebViewWalletRpcExecutor
import io.privy.wallet.webview.WebViewHandler
import io.privy.wallet.webview.WebViewWalletConnector
import kotlin.Lazy
import kotlin.reflect.KClass
import me.tatarka.inject.`internal`.LazyMap
import me.tatarka.inject.`internal`.ScopedComponent

public fun KClass<KmpAppComponent>.create(
  context: Context,
  privyAppId: PrivyAppId,
  privyAppClientId: PrivyAppClientId,
  privyLogLevel: PrivyLogLevel,
  appBundleIdentifier: AppBundleIdentifier,
  webViewHandler: WebViewHandler,
  privyEnvironment: PrivyEnvironment,
  privyInternalSettings: PrivyInternalSettings?,
  networkStateManager: NetworkStateManager,
  pkceHelper: PKCEHelper,
  oAuthHandler: OAuthHandler,
): KmpAppComponent = InjectKmpAppComponent(context, privyAppId, privyAppClientId, privyLogLevel,
    appBundleIdentifier, webViewHandler, privyEnvironment, privyInternalSettings,
    networkStateManager, pkceHelper, oAuthHandler)

public class InjectKmpAppComponent(
  context: Context,
  privyAppId: PrivyAppId,
  privyAppClientId: PrivyAppClientId,
  privyLogLevel: PrivyLogLevel,
  appBundleIdentifier: AppBundleIdentifier,
  webViewHandler: WebViewHandler,
  privyEnvironment: PrivyEnvironment,
  privyInternalSettings: PrivyInternalSettings?,
  networkStateManager: NetworkStateManager,
  pkceHelper: PKCEHelper,
  oAuthHandler: OAuthHandler,
) : KmpAppComponent(context, privyAppId, privyAppClientId, privyLogLevel, appBundleIdentifier,
    webViewHandler, privyEnvironment, privyInternalSettings, networkStateManager, pkceHelper,
    oAuthHandler), ScopedComponent {
  override val _scoped: LazyMap = LazyMap()

  private val internalAuthStateRepository: InternalAuthStateRepository
    get() = authStateRepository(
      real = realInternalAuthStateRepository
    )

  private val realInternalAuthStateRepository: RealInternalAuthStateRepository
    get() = _scoped.get("io.privy.auth.`internal`.RealInternalAuthStateRepository") {
      RealInternalAuthStateRepository(
        authSessionDataStore = _scoped.get("io.privy.auth.persistence.AuthSessionDataStore") {
          _scoped.get("io.privy.auth.persistence.RealAuthSessionDataStore") {
            RealAuthSessionDataStore(
              authSessionDataStoreHolder =
                  _scoped.get("io.privy.auth.persistence.AuthSessionDataStoreHolder") {
                providePreferencesDataStore(
                  context = context
                )
              },
              authSessionSerializer = RealInternalAuthSessionSerializer().bind()
            )
          }.bind()
        }
      )
    }

  private val authRepository: AuthRepository
    get() = RealAuthRepository(
      ktorWrapper = ktorWrapper,
      privyLogger = privyLogger,
      authSessionResponseDeserializer = RealAuthSessionResponseDeserializer().bind(),
      mapRawAuthSessionResponseToAuthSessionResponse =
          RealMapRawAuthSessionResponseToAuthSessionResponse(
        logger = privyLogger
      ).bind()
    ).bind()

  private val ktorWrapper: KtorWrapper
    get() = KtorWrapper(
      privyInternalSettings = privyInternalSettings,
      ktorProvider = _scoped.get("io.privy.network.KtorProvider") {
        provideKtorProvider(
          privyEnvironment = privyEnvironment,
          logger = privyLogger,
          privyAppId = privyAppId,
          privyAppClientId = privyAppClientId,
          appBundleIdentifier = appBundleIdentifier
        )
      },
      clientAnalyticsIdRepository = clientAnalyticsIdRepository,
      networkStateManager = networkStateManager
    )

  private val internalInternalAuthStateRepository: InternalInternalAuthStateRepository
    get() = internalAuthStateRepository(
      real = realInternalAuthStateRepository
    )

  private val decodeJwt: DecodeJwt
    get() = RealDecodeJwt().bind()

  private val authRefreshService: AuthRefreshService
    get() = authRefreshService(
      real = _scoped.get("io.privy.auth.RealAuthRefreshService") {
        RealAuthRefreshService(
          authRepository = authRepository
        )
      }
    )

  private val webViewWalletConnector: WebViewWalletConnector
    get() = _scoped.get("io.privy.wallet.webview.WebViewWalletConnector") {
      RealWebViewWalletConnector(
        webViewHandler = webViewHandler,
        privyLogger = privyLogger,
        internalAuthStateRepository = internalAuthStateRepository
      ).bind()
    }

  private val lazyWalletRpcExecutor: Lazy<WalletRpcExecutor>
    get() = lazy {
      RealWebViewWalletRpcExecutor(
        webViewWalletConnector = webViewWalletConnector,
        webViewHandler = webViewHandler,
        privyLogger = privyLogger
      ).bind()
    }

  private val jsonCanonicalizer: JsonCanonicalizer
    get() = RealJsonCanonicalizer().bind()

  private val appConfigRepository: AppConfigRepository
    get() = _scoped.get("io.privy.appconfig.AppConfigRepository") {
      RealAppConfigRepository(
        ktorWrapper = ktorWrapper,
        appId = privyAppId,
        privyLogger = privyLogger
      ).bind()
    }

  private val lazyWalletCreator: Lazy<WalletCreator>
    get() = lazy {
      RealWebViewWalletCreator(
        webViewHandler = webViewHandler,
        privyLogger = privyLogger
      ).bind()
    }

  private val embeddedWalletRepository: EmbeddedWalletRepository
    get() = _scoped.get("io.privy.wallet.EmbeddedWalletRepository") {
      RealEmbeddedWalletRepository(
        ktorWrapper = ktorWrapper,
        privyLogger = privyLogger,
        privyAppId = privyAppId
      ).bind()
    }

  override val auth: PrivyAuth
    get() = run<PrivyAuth> {
      lateinit var privyAuth: PrivyAuth
      RealPrivyAuth(
        internalAuthStateRepository = internalAuthStateRepository,
        internalAuthManager = _scoped.get("io.privy.auth.`internal`.InternalAuthManager") {
          RealInternalAuthManager(
            authRepository = authRepository,
            authStateRepository = internalInternalAuthStateRepository,
            privyLogger = privyLogger,
            decodeJwt = decodeJwt,
            authRefreshService = authRefreshService,
            networkStateManager = networkStateManager,
            privyUserCreator = { arg0 ->
              RealPrivyUser(
                internalAuthManager = arg0,
                embeddedEthereumWalletFactory = RealEmbeddedEthereumWalletFactory(
                  embeddedEthereumWalletCreator = { arg0_ ->
                    RealEmbeddedEthereumWallet(
                      embeddedWalletDetails = arg0_,
                      embeddedEthereumWalletProviderCreator = { arg0__ ->
                        RealEmbeddedEthereumWalletProvider(
                          embeddedWalletDetails = arg0__,
                          embeddedWalletManager =
                              _scoped.get("io.privy.wallet.EmbeddedWalletManager") {
                            RealEmbeddedWalletManager(
                              privyLogger = privyLogger,
                              internalAuthStateRepository = internalAuthStateRepository,
                              webViewWalletConnector = webViewWalletConnector,
                              rpcExecutorFactory = RealWalletRpcExecutorFactory(
                                lazyWebViewWalletRPCExecutor = lazyWalletRpcExecutor,
                                lazyWalletApiRPCExecutor = lazy {
                                  RealWalletApiRpcExecutor(
                                    walletApi = RealWalletApiRepository(
                                      ktorWrapper = ktorWrapper,
                                      userSignerProvider = {
                                        RealUserSigner(
                                          webViewHandler = webViewHandler,
                                          privyAuth = privyAuth
                                        ).bind()
                                      },
                                      appId = privyAppId,
                                      environment = privyEnvironment,
                                      jsonCanonicalizer = jsonCanonicalizer
                                    ).bind()
                                  ).bind()
                                }
                              ).bind(),
                              lazyPrivyAuth = lazy {
                                privyAuth
                              },
                              appConfigRepository = appConfigRepository,
                              walletCreatorFactory = RealWalletCreatorFactory(
                                lazyRealWebViewWalletCreator = lazyWalletCreator,
                                lazyWalletApiWalletCreator = lazy {
                                  RealWalletApiWalletCreator(
                                    walletApiRepository = RealWalletApiRepository(
                                      ktorWrapper = ktorWrapper,
                                      userSignerProvider = {
                                        RealUserSigner(
                                          webViewHandler = webViewHandler,
                                          privyAuth = privyAuth
                                        ).bind()
                                      },
                                      appId = privyAppId,
                                      environment = privyEnvironment,
                                      jsonCanonicalizer = jsonCanonicalizer
                                    ).bind(),
                                    privyLogger = privyLogger
                                  ).bind()
                                }
                              ).bind(),
                              embeddedWalletRepository = embeddedWalletRepository
                            ).bind()
                          },
                          privyLogger = privyLogger
                        ).bind()
                      }
                    ).bind()
                  }
                ).bind(),
                embeddedSolanaWalletFactory = RealEmbeddedSolanaWalletFactory(
                  embeddedSolanaWalletCreator = { arg0_ ->
                    RealEmbeddedSolanaWallet(
                      embeddedWalletDetails = arg0_,
                      rpcProviderCreator = { arg0__ ->
                        RealEmbeddedSolanaWalletProvider(
                          embeddedWalletDetails = arg0__,
                          embeddedWalletManager =
                              _scoped.get("io.privy.wallet.EmbeddedWalletManager") {
                            RealEmbeddedWalletManager(
                              privyLogger = privyLogger,
                              internalAuthStateRepository = internalAuthStateRepository,
                              webViewWalletConnector = webViewWalletConnector,
                              rpcExecutorFactory = RealWalletRpcExecutorFactory(
                                lazyWebViewWalletRPCExecutor = lazyWalletRpcExecutor,
                                lazyWalletApiRPCExecutor = lazy {
                                  RealWalletApiRpcExecutor(
                                    walletApi = RealWalletApiRepository(
                                      ktorWrapper = ktorWrapper,
                                      userSignerProvider = {
                                        RealUserSigner(
                                          webViewHandler = webViewHandler,
                                          privyAuth = privyAuth
                                        ).bind()
                                      },
                                      appId = privyAppId,
                                      environment = privyEnvironment,
                                      jsonCanonicalizer = jsonCanonicalizer
                                    ).bind()
                                  ).bind()
                                }
                              ).bind(),
                              lazyPrivyAuth = lazy {
                                privyAuth
                              },
                              appConfigRepository = appConfigRepository,
                              walletCreatorFactory = RealWalletCreatorFactory(
                                lazyRealWebViewWalletCreator = lazyWalletCreator,
                                lazyWalletApiWalletCreator = lazy {
                                  RealWalletApiWalletCreator(
                                    walletApiRepository = RealWalletApiRepository(
                                      ktorWrapper = ktorWrapper,
                                      userSignerProvider = {
                                        RealUserSigner(
                                          webViewHandler = webViewHandler,
                                          privyAuth = privyAuth
                                        ).bind()
                                      },
                                      appId = privyAppId,
                                      environment = privyEnvironment,
                                      jsonCanonicalizer = jsonCanonicalizer
                                    ).bind(),
                                    privyLogger = privyLogger
                                  ).bind()
                                }
                              ).bind(),
                              embeddedWalletRepository = embeddedWalletRepository
                            ).bind()
                          },
                          privyLogger = privyLogger
                        ).bind()
                      }
                    ).bind()
                  }
                ).bind(),
                embeddedWalletManager = _scoped.get("io.privy.wallet.EmbeddedWalletManager") {
                  RealEmbeddedWalletManager(
                    privyLogger = privyLogger,
                    internalAuthStateRepository = internalAuthStateRepository,
                    webViewWalletConnector = webViewWalletConnector,
                    rpcExecutorFactory = RealWalletRpcExecutorFactory(
                      lazyWebViewWalletRPCExecutor = lazyWalletRpcExecutor,
                      lazyWalletApiRPCExecutor = lazy {
                        RealWalletApiRpcExecutor(
                          walletApi = RealWalletApiRepository(
                            ktorWrapper = ktorWrapper,
                            userSignerProvider = {
                              RealUserSigner(
                                webViewHandler = webViewHandler,
                                privyAuth = privyAuth
                              ).bind()
                            },
                            appId = privyAppId,
                            environment = privyEnvironment,
                            jsonCanonicalizer = jsonCanonicalizer
                          ).bind()
                        ).bind()
                      }
                    ).bind(),
                    lazyPrivyAuth = lazy {
                      privyAuth
                    },
                    appConfigRepository = appConfigRepository,
                    walletCreatorFactory = RealWalletCreatorFactory(
                      lazyRealWebViewWalletCreator = lazyWalletCreator,
                      lazyWalletApiWalletCreator = lazy {
                        RealWalletApiWalletCreator(
                          walletApiRepository = RealWalletApiRepository(
                            ktorWrapper = ktorWrapper,
                            userSignerProvider = {
                              RealUserSigner(
                                webViewHandler = webViewHandler,
                                privyAuth = privyAuth
                              ).bind()
                            },
                            appId = privyAppId,
                            environment = privyEnvironment,
                            jsonCanonicalizer = jsonCanonicalizer
                          ).bind(),
                          privyLogger = privyLogger
                        ).bind()
                      }
                    ).bind(),
                    embeddedWalletRepository = embeddedWalletRepository
                  ).bind()
                },
                privyLogger = privyLogger
              ).bind()
            }
          ).bind()
        },
        clientAnalyticsIdRepository = clientAnalyticsIdRepository,
        privyLogger = privyLogger,
        sms = RealLoginWithSms(
          authRepository = authRepository,
          internalAuthManager = _scoped.get("io.privy.auth.`internal`.InternalAuthManager") {
            RealInternalAuthManager(
              authRepository = authRepository,
              authStateRepository = internalInternalAuthStateRepository,
              privyLogger = privyLogger,
              decodeJwt = decodeJwt,
              authRefreshService = authRefreshService,
              networkStateManager = networkStateManager,
              privyUserCreator = { arg0 ->
                RealPrivyUser(
                  internalAuthManager = arg0,
                  embeddedEthereumWalletFactory = RealEmbeddedEthereumWalletFactory(
                    embeddedEthereumWalletCreator = { arg0_ ->
                      RealEmbeddedEthereumWallet(
                        embeddedWalletDetails = arg0_,
                        embeddedEthereumWalletProviderCreator = { arg0__ ->
                          RealEmbeddedEthereumWalletProvider(
                            embeddedWalletDetails = arg0__,
                            embeddedWalletManager =
                                _scoped.get("io.privy.wallet.EmbeddedWalletManager") {
                              RealEmbeddedWalletManager(
                                privyLogger = privyLogger,
                                internalAuthStateRepository = internalAuthStateRepository,
                                webViewWalletConnector = webViewWalletConnector,
                                rpcExecutorFactory = RealWalletRpcExecutorFactory(
                                  lazyWebViewWalletRPCExecutor = lazyWalletRpcExecutor,
                                  lazyWalletApiRPCExecutor = lazy {
                                    RealWalletApiRpcExecutor(
                                      walletApi = RealWalletApiRepository(
                                        ktorWrapper = ktorWrapper,
                                        userSignerProvider = {
                                          RealUserSigner(
                                            webViewHandler = webViewHandler,
                                            privyAuth = privyAuth
                                          ).bind()
                                        },
                                        appId = privyAppId,
                                        environment = privyEnvironment,
                                        jsonCanonicalizer = jsonCanonicalizer
                                      ).bind()
                                    ).bind()
                                  }
                                ).bind(),
                                lazyPrivyAuth = lazy {
                                  privyAuth
                                },
                                appConfigRepository = appConfigRepository,
                                walletCreatorFactory = RealWalletCreatorFactory(
                                  lazyRealWebViewWalletCreator = lazyWalletCreator,
                                  lazyWalletApiWalletCreator = lazy {
                                    RealWalletApiWalletCreator(
                                      walletApiRepository = RealWalletApiRepository(
                                        ktorWrapper = ktorWrapper,
                                        userSignerProvider = {
                                          RealUserSigner(
                                            webViewHandler = webViewHandler,
                                            privyAuth = privyAuth
                                          ).bind()
                                        },
                                        appId = privyAppId,
                                        environment = privyEnvironment,
                                        jsonCanonicalizer = jsonCanonicalizer
                                      ).bind(),
                                      privyLogger = privyLogger
                                    ).bind()
                                  }
                                ).bind(),
                                embeddedWalletRepository = embeddedWalletRepository
                              ).bind()
                            },
                            privyLogger = privyLogger
                          ).bind()
                        }
                      ).bind()
                    }
                  ).bind(),
                  embeddedSolanaWalletFactory = RealEmbeddedSolanaWalletFactory(
                    embeddedSolanaWalletCreator = { arg0_ ->
                      RealEmbeddedSolanaWallet(
                        embeddedWalletDetails = arg0_,
                        rpcProviderCreator = { arg0__ ->
                          RealEmbeddedSolanaWalletProvider(
                            embeddedWalletDetails = arg0__,
                            embeddedWalletManager =
                                _scoped.get("io.privy.wallet.EmbeddedWalletManager") {
                              RealEmbeddedWalletManager(
                                privyLogger = privyLogger,
                                internalAuthStateRepository = internalAuthStateRepository,
                                webViewWalletConnector = webViewWalletConnector,
                                rpcExecutorFactory = RealWalletRpcExecutorFactory(
                                  lazyWebViewWalletRPCExecutor = lazyWalletRpcExecutor,
                                  lazyWalletApiRPCExecutor = lazy {
                                    RealWalletApiRpcExecutor(
                                      walletApi = RealWalletApiRepository(
                                        ktorWrapper = ktorWrapper,
                                        userSignerProvider = {
                                          RealUserSigner(
                                            webViewHandler = webViewHandler,
                                            privyAuth = privyAuth
                                          ).bind()
                                        },
                                        appId = privyAppId,
                                        environment = privyEnvironment,
                                        jsonCanonicalizer = jsonCanonicalizer
                                      ).bind()
                                    ).bind()
                                  }
                                ).bind(),
                                lazyPrivyAuth = lazy {
                                  privyAuth
                                },
                                appConfigRepository = appConfigRepository,
                                walletCreatorFactory = RealWalletCreatorFactory(
                                  lazyRealWebViewWalletCreator = lazyWalletCreator,
                                  lazyWalletApiWalletCreator = lazy {
                                    RealWalletApiWalletCreator(
                                      walletApiRepository = RealWalletApiRepository(
                                        ktorWrapper = ktorWrapper,
                                        userSignerProvider = {
                                          RealUserSigner(
                                            webViewHandler = webViewHandler,
                                            privyAuth = privyAuth
                                          ).bind()
                                        },
                                        appId = privyAppId,
                                        environment = privyEnvironment,
                                        jsonCanonicalizer = jsonCanonicalizer
                                      ).bind(),
                                      privyLogger = privyLogger
                                    ).bind()
                                  }
                                ).bind(),
                                embeddedWalletRepository = embeddedWalletRepository
                              ).bind()
                            },
                            privyLogger = privyLogger
                          ).bind()
                        }
                      ).bind()
                    }
                  ).bind(),
                  embeddedWalletManager = _scoped.get("io.privy.wallet.EmbeddedWalletManager") {
                    RealEmbeddedWalletManager(
                      privyLogger = privyLogger,
                      internalAuthStateRepository = internalAuthStateRepository,
                      webViewWalletConnector = webViewWalletConnector,
                      rpcExecutorFactory = RealWalletRpcExecutorFactory(
                        lazyWebViewWalletRPCExecutor = lazyWalletRpcExecutor,
                        lazyWalletApiRPCExecutor = lazy {
                          RealWalletApiRpcExecutor(
                            walletApi = RealWalletApiRepository(
                              ktorWrapper = ktorWrapper,
                              userSignerProvider = {
                                RealUserSigner(
                                  webViewHandler = webViewHandler,
                                  privyAuth = privyAuth
                                ).bind()
                              },
                              appId = privyAppId,
                              environment = privyEnvironment,
                              jsonCanonicalizer = jsonCanonicalizer
                            ).bind()
                          ).bind()
                        }
                      ).bind(),
                      lazyPrivyAuth = lazy {
                        privyAuth
                      },
                      appConfigRepository = appConfigRepository,
                      walletCreatorFactory = RealWalletCreatorFactory(
                        lazyRealWebViewWalletCreator = lazyWalletCreator,
                        lazyWalletApiWalletCreator = lazy {
                          RealWalletApiWalletCreator(
                            walletApiRepository = RealWalletApiRepository(
                              ktorWrapper = ktorWrapper,
                              userSignerProvider = {
                                RealUserSigner(
                                  webViewHandler = webViewHandler,
                                  privyAuth = privyAuth
                                ).bind()
                              },
                              appId = privyAppId,
                              environment = privyEnvironment,
                              jsonCanonicalizer = jsonCanonicalizer
                            ).bind(),
                            privyLogger = privyLogger
                          ).bind()
                        }
                      ).bind(),
                      embeddedWalletRepository = embeddedWalletRepository
                    ).bind()
                  },
                  privyLogger = privyLogger
                ).bind()
              }
            ).bind()
          },
          privyLogger = privyLogger
        ).bind(),
        email = RealLoginWithEmail(
          authRepository = authRepository,
          internalAuthManager = _scoped.get("io.privy.auth.`internal`.InternalAuthManager") {
            RealInternalAuthManager(
              authRepository = authRepository,
              authStateRepository = internalInternalAuthStateRepository,
              privyLogger = privyLogger,
              decodeJwt = decodeJwt,
              authRefreshService = authRefreshService,
              networkStateManager = networkStateManager,
              privyUserCreator = { arg0 ->
                RealPrivyUser(
                  internalAuthManager = arg0,
                  embeddedEthereumWalletFactory = RealEmbeddedEthereumWalletFactory(
                    embeddedEthereumWalletCreator = { arg0_ ->
                      RealEmbeddedEthereumWallet(
                        embeddedWalletDetails = arg0_,
                        embeddedEthereumWalletProviderCreator = { arg0__ ->
                          RealEmbeddedEthereumWalletProvider(
                            embeddedWalletDetails = arg0__,
                            embeddedWalletManager =
                                _scoped.get("io.privy.wallet.EmbeddedWalletManager") {
                              RealEmbeddedWalletManager(
                                privyLogger = privyLogger,
                                internalAuthStateRepository = internalAuthStateRepository,
                                webViewWalletConnector = webViewWalletConnector,
                                rpcExecutorFactory = RealWalletRpcExecutorFactory(
                                  lazyWebViewWalletRPCExecutor = lazyWalletRpcExecutor,
                                  lazyWalletApiRPCExecutor = lazy {
                                    RealWalletApiRpcExecutor(
                                      walletApi = RealWalletApiRepository(
                                        ktorWrapper = ktorWrapper,
                                        userSignerProvider = {
                                          RealUserSigner(
                                            webViewHandler = webViewHandler,
                                            privyAuth = privyAuth
                                          ).bind()
                                        },
                                        appId = privyAppId,
                                        environment = privyEnvironment,
                                        jsonCanonicalizer = jsonCanonicalizer
                                      ).bind()
                                    ).bind()
                                  }
                                ).bind(),
                                lazyPrivyAuth = lazy {
                                  privyAuth
                                },
                                appConfigRepository = appConfigRepository,
                                walletCreatorFactory = RealWalletCreatorFactory(
                                  lazyRealWebViewWalletCreator = lazyWalletCreator,
                                  lazyWalletApiWalletCreator = lazy {
                                    RealWalletApiWalletCreator(
                                      walletApiRepository = RealWalletApiRepository(
                                        ktorWrapper = ktorWrapper,
                                        userSignerProvider = {
                                          RealUserSigner(
                                            webViewHandler = webViewHandler,
                                            privyAuth = privyAuth
                                          ).bind()
                                        },
                                        appId = privyAppId,
                                        environment = privyEnvironment,
                                        jsonCanonicalizer = jsonCanonicalizer
                                      ).bind(),
                                      privyLogger = privyLogger
                                    ).bind()
                                  }
                                ).bind(),
                                embeddedWalletRepository = embeddedWalletRepository
                              ).bind()
                            },
                            privyLogger = privyLogger
                          ).bind()
                        }
                      ).bind()
                    }
                  ).bind(),
                  embeddedSolanaWalletFactory = RealEmbeddedSolanaWalletFactory(
                    embeddedSolanaWalletCreator = { arg0_ ->
                      RealEmbeddedSolanaWallet(
                        embeddedWalletDetails = arg0_,
                        rpcProviderCreator = { arg0__ ->
                          RealEmbeddedSolanaWalletProvider(
                            embeddedWalletDetails = arg0__,
                            embeddedWalletManager =
                                _scoped.get("io.privy.wallet.EmbeddedWalletManager") {
                              RealEmbeddedWalletManager(
                                privyLogger = privyLogger,
                                internalAuthStateRepository = internalAuthStateRepository,
                                webViewWalletConnector = webViewWalletConnector,
                                rpcExecutorFactory = RealWalletRpcExecutorFactory(
                                  lazyWebViewWalletRPCExecutor = lazyWalletRpcExecutor,
                                  lazyWalletApiRPCExecutor = lazy {
                                    RealWalletApiRpcExecutor(
                                      walletApi = RealWalletApiRepository(
                                        ktorWrapper = ktorWrapper,
                                        userSignerProvider = {
                                          RealUserSigner(
                                            webViewHandler = webViewHandler,
                                            privyAuth = privyAuth
                                          ).bind()
                                        },
                                        appId = privyAppId,
                                        environment = privyEnvironment,
                                        jsonCanonicalizer = jsonCanonicalizer
                                      ).bind()
                                    ).bind()
                                  }
                                ).bind(),
                                lazyPrivyAuth = lazy {
                                  privyAuth
                                },
                                appConfigRepository = appConfigRepository,
                                walletCreatorFactory = RealWalletCreatorFactory(
                                  lazyRealWebViewWalletCreator = lazyWalletCreator,
                                  lazyWalletApiWalletCreator = lazy {
                                    RealWalletApiWalletCreator(
                                      walletApiRepository = RealWalletApiRepository(
                                        ktorWrapper = ktorWrapper,
                                        userSignerProvider = {
                                          RealUserSigner(
                                            webViewHandler = webViewHandler,
                                            privyAuth = privyAuth
                                          ).bind()
                                        },
                                        appId = privyAppId,
                                        environment = privyEnvironment,
                                        jsonCanonicalizer = jsonCanonicalizer
                                      ).bind(),
                                      privyLogger = privyLogger
                                    ).bind()
                                  }
                                ).bind(),
                                embeddedWalletRepository = embeddedWalletRepository
                              ).bind()
                            },
                            privyLogger = privyLogger
                          ).bind()
                        }
                      ).bind()
                    }
                  ).bind(),
                  embeddedWalletManager = _scoped.get("io.privy.wallet.EmbeddedWalletManager") {
                    RealEmbeddedWalletManager(
                      privyLogger = privyLogger,
                      internalAuthStateRepository = internalAuthStateRepository,
                      webViewWalletConnector = webViewWalletConnector,
                      rpcExecutorFactory = RealWalletRpcExecutorFactory(
                        lazyWebViewWalletRPCExecutor = lazyWalletRpcExecutor,
                        lazyWalletApiRPCExecutor = lazy {
                          RealWalletApiRpcExecutor(
                            walletApi = RealWalletApiRepository(
                              ktorWrapper = ktorWrapper,
                              userSignerProvider = {
                                RealUserSigner(
                                  webViewHandler = webViewHandler,
                                  privyAuth = privyAuth
                                ).bind()
                              },
                              appId = privyAppId,
                              environment = privyEnvironment,
                              jsonCanonicalizer = jsonCanonicalizer
                            ).bind()
                          ).bind()
                        }
                      ).bind(),
                      lazyPrivyAuth = lazy {
                        privyAuth
                      },
                      appConfigRepository = appConfigRepository,
                      walletCreatorFactory = RealWalletCreatorFactory(
                        lazyRealWebViewWalletCreator = lazyWalletCreator,
                        lazyWalletApiWalletCreator = lazy {
                          RealWalletApiWalletCreator(
                            walletApiRepository = RealWalletApiRepository(
                              ktorWrapper = ktorWrapper,
                              userSignerProvider = {
                                RealUserSigner(
                                  webViewHandler = webViewHandler,
                                  privyAuth = privyAuth
                                ).bind()
                              },
                              appId = privyAppId,
                              environment = privyEnvironment,
                              jsonCanonicalizer = jsonCanonicalizer
                            ).bind(),
                            privyLogger = privyLogger
                          ).bind()
                        }
                      ).bind(),
                      embeddedWalletRepository = embeddedWalletRepository
                    ).bind()
                  },
                  privyLogger = privyLogger
                ).bind()
              }
            ).bind()
          },
          privyLogger = privyLogger
        ).bind(),
        customAuth = RealLoginWithCustomAuth(
          internalAuthManager = _scoped.get("io.privy.auth.`internal`.InternalAuthManager") {
            RealInternalAuthManager(
              authRepository = authRepository,
              authStateRepository = internalInternalAuthStateRepository,
              privyLogger = privyLogger,
              decodeJwt = decodeJwt,
              authRefreshService = authRefreshService,
              networkStateManager = networkStateManager,
              privyUserCreator = { arg0 ->
                RealPrivyUser(
                  internalAuthManager = arg0,
                  embeddedEthereumWalletFactory = RealEmbeddedEthereumWalletFactory(
                    embeddedEthereumWalletCreator = { arg0_ ->
                      RealEmbeddedEthereumWallet(
                        embeddedWalletDetails = arg0_,
                        embeddedEthereumWalletProviderCreator = { arg0__ ->
                          RealEmbeddedEthereumWalletProvider(
                            embeddedWalletDetails = arg0__,
                            embeddedWalletManager =
                                _scoped.get("io.privy.wallet.EmbeddedWalletManager") {
                              RealEmbeddedWalletManager(
                                privyLogger = privyLogger,
                                internalAuthStateRepository = internalAuthStateRepository,
                                webViewWalletConnector = webViewWalletConnector,
                                rpcExecutorFactory = RealWalletRpcExecutorFactory(
                                  lazyWebViewWalletRPCExecutor = lazyWalletRpcExecutor,
                                  lazyWalletApiRPCExecutor = lazy {
                                    RealWalletApiRpcExecutor(
                                      walletApi = RealWalletApiRepository(
                                        ktorWrapper = ktorWrapper,
                                        userSignerProvider = {
                                          RealUserSigner(
                                            webViewHandler = webViewHandler,
                                            privyAuth = privyAuth
                                          ).bind()
                                        },
                                        appId = privyAppId,
                                        environment = privyEnvironment,
                                        jsonCanonicalizer = jsonCanonicalizer
                                      ).bind()
                                    ).bind()
                                  }
                                ).bind(),
                                lazyPrivyAuth = lazy {
                                  privyAuth
                                },
                                appConfigRepository = appConfigRepository,
                                walletCreatorFactory = RealWalletCreatorFactory(
                                  lazyRealWebViewWalletCreator = lazyWalletCreator,
                                  lazyWalletApiWalletCreator = lazy {
                                    RealWalletApiWalletCreator(
                                      walletApiRepository = RealWalletApiRepository(
                                        ktorWrapper = ktorWrapper,
                                        userSignerProvider = {
                                          RealUserSigner(
                                            webViewHandler = webViewHandler,
                                            privyAuth = privyAuth
                                          ).bind()
                                        },
                                        appId = privyAppId,
                                        environment = privyEnvironment,
                                        jsonCanonicalizer = jsonCanonicalizer
                                      ).bind(),
                                      privyLogger = privyLogger
                                    ).bind()
                                  }
                                ).bind(),
                                embeddedWalletRepository = embeddedWalletRepository
                              ).bind()
                            },
                            privyLogger = privyLogger
                          ).bind()
                        }
                      ).bind()
                    }
                  ).bind(),
                  embeddedSolanaWalletFactory = RealEmbeddedSolanaWalletFactory(
                    embeddedSolanaWalletCreator = { arg0_ ->
                      RealEmbeddedSolanaWallet(
                        embeddedWalletDetails = arg0_,
                        rpcProviderCreator = { arg0__ ->
                          RealEmbeddedSolanaWalletProvider(
                            embeddedWalletDetails = arg0__,
                            embeddedWalletManager =
                                _scoped.get("io.privy.wallet.EmbeddedWalletManager") {
                              RealEmbeddedWalletManager(
                                privyLogger = privyLogger,
                                internalAuthStateRepository = internalAuthStateRepository,
                                webViewWalletConnector = webViewWalletConnector,
                                rpcExecutorFactory = RealWalletRpcExecutorFactory(
                                  lazyWebViewWalletRPCExecutor = lazyWalletRpcExecutor,
                                  lazyWalletApiRPCExecutor = lazy {
                                    RealWalletApiRpcExecutor(
                                      walletApi = RealWalletApiRepository(
                                        ktorWrapper = ktorWrapper,
                                        userSignerProvider = {
                                          RealUserSigner(
                                            webViewHandler = webViewHandler,
                                            privyAuth = privyAuth
                                          ).bind()
                                        },
                                        appId = privyAppId,
                                        environment = privyEnvironment,
                                        jsonCanonicalizer = jsonCanonicalizer
                                      ).bind()
                                    ).bind()
                                  }
                                ).bind(),
                                lazyPrivyAuth = lazy {
                                  privyAuth
                                },
                                appConfigRepository = appConfigRepository,
                                walletCreatorFactory = RealWalletCreatorFactory(
                                  lazyRealWebViewWalletCreator = lazyWalletCreator,
                                  lazyWalletApiWalletCreator = lazy {
                                    RealWalletApiWalletCreator(
                                      walletApiRepository = RealWalletApiRepository(
                                        ktorWrapper = ktorWrapper,
                                        userSignerProvider = {
                                          RealUserSigner(
                                            webViewHandler = webViewHandler,
                                            privyAuth = privyAuth
                                          ).bind()
                                        },
                                        appId = privyAppId,
                                        environment = privyEnvironment,
                                        jsonCanonicalizer = jsonCanonicalizer
                                      ).bind(),
                                      privyLogger = privyLogger
                                    ).bind()
                                  }
                                ).bind(),
                                embeddedWalletRepository = embeddedWalletRepository
                              ).bind()
                            },
                            privyLogger = privyLogger
                          ).bind()
                        }
                      ).bind()
                    }
                  ).bind(),
                  embeddedWalletManager = _scoped.get("io.privy.wallet.EmbeddedWalletManager") {
                    RealEmbeddedWalletManager(
                      privyLogger = privyLogger,
                      internalAuthStateRepository = internalAuthStateRepository,
                      webViewWalletConnector = webViewWalletConnector,
                      rpcExecutorFactory = RealWalletRpcExecutorFactory(
                        lazyWebViewWalletRPCExecutor = lazyWalletRpcExecutor,
                        lazyWalletApiRPCExecutor = lazy {
                          RealWalletApiRpcExecutor(
                            walletApi = RealWalletApiRepository(
                              ktorWrapper = ktorWrapper,
                              userSignerProvider = {
                                RealUserSigner(
                                  webViewHandler = webViewHandler,
                                  privyAuth = privyAuth
                                ).bind()
                              },
                              appId = privyAppId,
                              environment = privyEnvironment,
                              jsonCanonicalizer = jsonCanonicalizer
                            ).bind()
                          ).bind()
                        }
                      ).bind(),
                      lazyPrivyAuth = lazy {
                        privyAuth
                      },
                      appConfigRepository = appConfigRepository,
                      walletCreatorFactory = RealWalletCreatorFactory(
                        lazyRealWebViewWalletCreator = lazyWalletCreator,
                        lazyWalletApiWalletCreator = lazy {
                          RealWalletApiWalletCreator(
                            walletApiRepository = RealWalletApiRepository(
                              ktorWrapper = ktorWrapper,
                              userSignerProvider = {
                                RealUserSigner(
                                  webViewHandler = webViewHandler,
                                  privyAuth = privyAuth
                                ).bind()
                              },
                              appId = privyAppId,
                              environment = privyEnvironment,
                              jsonCanonicalizer = jsonCanonicalizer
                            ).bind(),
                            privyLogger = privyLogger
                          ).bind()
                        }
                      ).bind(),
                      embeddedWalletRepository = embeddedWalletRepository
                    ).bind()
                  },
                  privyLogger = privyLogger
                ).bind()
              }
            ).bind()
          }
        ).bind(),
        siwe = RealLoginWithSiwe(
          authRepository = authRepository,
          internalAuthManager = _scoped.get("io.privy.auth.`internal`.InternalAuthManager") {
            RealInternalAuthManager(
              authRepository = authRepository,
              authStateRepository = internalInternalAuthStateRepository,
              privyLogger = privyLogger,
              decodeJwt = decodeJwt,
              authRefreshService = authRefreshService,
              networkStateManager = networkStateManager,
              privyUserCreator = { arg0 ->
                RealPrivyUser(
                  internalAuthManager = arg0,
                  embeddedEthereumWalletFactory = RealEmbeddedEthereumWalletFactory(
                    embeddedEthereumWalletCreator = { arg0_ ->
                      RealEmbeddedEthereumWallet(
                        embeddedWalletDetails = arg0_,
                        embeddedEthereumWalletProviderCreator = { arg0__ ->
                          RealEmbeddedEthereumWalletProvider(
                            embeddedWalletDetails = arg0__,
                            embeddedWalletManager =
                                _scoped.get("io.privy.wallet.EmbeddedWalletManager") {
                              RealEmbeddedWalletManager(
                                privyLogger = privyLogger,
                                internalAuthStateRepository = internalAuthStateRepository,
                                webViewWalletConnector = webViewWalletConnector,
                                rpcExecutorFactory = RealWalletRpcExecutorFactory(
                                  lazyWebViewWalletRPCExecutor = lazyWalletRpcExecutor,
                                  lazyWalletApiRPCExecutor = lazy {
                                    RealWalletApiRpcExecutor(
                                      walletApi = RealWalletApiRepository(
                                        ktorWrapper = ktorWrapper,
                                        userSignerProvider = {
                                          RealUserSigner(
                                            webViewHandler = webViewHandler,
                                            privyAuth = privyAuth
                                          ).bind()
                                        },
                                        appId = privyAppId,
                                        environment = privyEnvironment,
                                        jsonCanonicalizer = jsonCanonicalizer
                                      ).bind()
                                    ).bind()
                                  }
                                ).bind(),
                                lazyPrivyAuth = lazy {
                                  privyAuth
                                },
                                appConfigRepository = appConfigRepository,
                                walletCreatorFactory = RealWalletCreatorFactory(
                                  lazyRealWebViewWalletCreator = lazyWalletCreator,
                                  lazyWalletApiWalletCreator = lazy {
                                    RealWalletApiWalletCreator(
                                      walletApiRepository = RealWalletApiRepository(
                                        ktorWrapper = ktorWrapper,
                                        userSignerProvider = {
                                          RealUserSigner(
                                            webViewHandler = webViewHandler,
                                            privyAuth = privyAuth
                                          ).bind()
                                        },
                                        appId = privyAppId,
                                        environment = privyEnvironment,
                                        jsonCanonicalizer = jsonCanonicalizer
                                      ).bind(),
                                      privyLogger = privyLogger
                                    ).bind()
                                  }
                                ).bind(),
                                embeddedWalletRepository = embeddedWalletRepository
                              ).bind()
                            },
                            privyLogger = privyLogger
                          ).bind()
                        }
                      ).bind()
                    }
                  ).bind(),
                  embeddedSolanaWalletFactory = RealEmbeddedSolanaWalletFactory(
                    embeddedSolanaWalletCreator = { arg0_ ->
                      RealEmbeddedSolanaWallet(
                        embeddedWalletDetails = arg0_,
                        rpcProviderCreator = { arg0__ ->
                          RealEmbeddedSolanaWalletProvider(
                            embeddedWalletDetails = arg0__,
                            embeddedWalletManager =
                                _scoped.get("io.privy.wallet.EmbeddedWalletManager") {
                              RealEmbeddedWalletManager(
                                privyLogger = privyLogger,
                                internalAuthStateRepository = internalAuthStateRepository,
                                webViewWalletConnector = webViewWalletConnector,
                                rpcExecutorFactory = RealWalletRpcExecutorFactory(
                                  lazyWebViewWalletRPCExecutor = lazyWalletRpcExecutor,
                                  lazyWalletApiRPCExecutor = lazy {
                                    RealWalletApiRpcExecutor(
                                      walletApi = RealWalletApiRepository(
                                        ktorWrapper = ktorWrapper,
                                        userSignerProvider = {
                                          RealUserSigner(
                                            webViewHandler = webViewHandler,
                                            privyAuth = privyAuth
                                          ).bind()
                                        },
                                        appId = privyAppId,
                                        environment = privyEnvironment,
                                        jsonCanonicalizer = jsonCanonicalizer
                                      ).bind()
                                    ).bind()
                                  }
                                ).bind(),
                                lazyPrivyAuth = lazy {
                                  privyAuth
                                },
                                appConfigRepository = appConfigRepository,
                                walletCreatorFactory = RealWalletCreatorFactory(
                                  lazyRealWebViewWalletCreator = lazyWalletCreator,
                                  lazyWalletApiWalletCreator = lazy {
                                    RealWalletApiWalletCreator(
                                      walletApiRepository = RealWalletApiRepository(
                                        ktorWrapper = ktorWrapper,
                                        userSignerProvider = {
                                          RealUserSigner(
                                            webViewHandler = webViewHandler,
                                            privyAuth = privyAuth
                                          ).bind()
                                        },
                                        appId = privyAppId,
                                        environment = privyEnvironment,
                                        jsonCanonicalizer = jsonCanonicalizer
                                      ).bind(),
                                      privyLogger = privyLogger
                                    ).bind()
                                  }
                                ).bind(),
                                embeddedWalletRepository = embeddedWalletRepository
                              ).bind()
                            },
                            privyLogger = privyLogger
                          ).bind()
                        }
                      ).bind()
                    }
                  ).bind(),
                  embeddedWalletManager = _scoped.get("io.privy.wallet.EmbeddedWalletManager") {
                    RealEmbeddedWalletManager(
                      privyLogger = privyLogger,
                      internalAuthStateRepository = internalAuthStateRepository,
                      webViewWalletConnector = webViewWalletConnector,
                      rpcExecutorFactory = RealWalletRpcExecutorFactory(
                        lazyWebViewWalletRPCExecutor = lazyWalletRpcExecutor,
                        lazyWalletApiRPCExecutor = lazy {
                          RealWalletApiRpcExecutor(
                            walletApi = RealWalletApiRepository(
                              ktorWrapper = ktorWrapper,
                              userSignerProvider = {
                                RealUserSigner(
                                  webViewHandler = webViewHandler,
                                  privyAuth = privyAuth
                                ).bind()
                              },
                              appId = privyAppId,
                              environment = privyEnvironment,
                              jsonCanonicalizer = jsonCanonicalizer
                            ).bind()
                          ).bind()
                        }
                      ).bind(),
                      lazyPrivyAuth = lazy {
                        privyAuth
                      },
                      appConfigRepository = appConfigRepository,
                      walletCreatorFactory = RealWalletCreatorFactory(
                        lazyRealWebViewWalletCreator = lazyWalletCreator,
                        lazyWalletApiWalletCreator = lazy {
                          RealWalletApiWalletCreator(
                            walletApiRepository = RealWalletApiRepository(
                              ktorWrapper = ktorWrapper,
                              userSignerProvider = {
                                RealUserSigner(
                                  webViewHandler = webViewHandler,
                                  privyAuth = privyAuth
                                ).bind()
                              },
                              appId = privyAppId,
                              environment = privyEnvironment,
                              jsonCanonicalizer = jsonCanonicalizer
                            ).bind(),
                            privyLogger = privyLogger
                          ).bind()
                        }
                      ).bind(),
                      embeddedWalletRepository = embeddedWalletRepository
                    ).bind()
                  },
                  privyLogger = privyLogger
                ).bind()
              }
            ).bind()
          }
        ).bind(),
        oAuth = RealLoginWithOAuth(
          oAuthHandler = oAuthHandler,
          pkceHelper = pkceHelper,
          authRepository = authRepository,
          internalAuthManager = _scoped.get("io.privy.auth.`internal`.InternalAuthManager") {
            RealInternalAuthManager(
              authRepository = authRepository,
              authStateRepository = internalInternalAuthStateRepository,
              privyLogger = privyLogger,
              decodeJwt = decodeJwt,
              authRefreshService = authRefreshService,
              networkStateManager = networkStateManager,
              privyUserCreator = { arg0 ->
                RealPrivyUser(
                  internalAuthManager = arg0,
                  embeddedEthereumWalletFactory = RealEmbeddedEthereumWalletFactory(
                    embeddedEthereumWalletCreator = { arg0_ ->
                      RealEmbeddedEthereumWallet(
                        embeddedWalletDetails = arg0_,
                        embeddedEthereumWalletProviderCreator = { arg0__ ->
                          RealEmbeddedEthereumWalletProvider(
                            embeddedWalletDetails = arg0__,
                            embeddedWalletManager =
                                _scoped.get("io.privy.wallet.EmbeddedWalletManager") {
                              RealEmbeddedWalletManager(
                                privyLogger = privyLogger,
                                internalAuthStateRepository = internalAuthStateRepository,
                                webViewWalletConnector = webViewWalletConnector,
                                rpcExecutorFactory = RealWalletRpcExecutorFactory(
                                  lazyWebViewWalletRPCExecutor = lazyWalletRpcExecutor,
                                  lazyWalletApiRPCExecutor = lazy {
                                    RealWalletApiRpcExecutor(
                                      walletApi = RealWalletApiRepository(
                                        ktorWrapper = ktorWrapper,
                                        userSignerProvider = {
                                          RealUserSigner(
                                            webViewHandler = webViewHandler,
                                            privyAuth = privyAuth
                                          ).bind()
                                        },
                                        appId = privyAppId,
                                        environment = privyEnvironment,
                                        jsonCanonicalizer = jsonCanonicalizer
                                      ).bind()
                                    ).bind()
                                  }
                                ).bind(),
                                lazyPrivyAuth = lazy {
                                  privyAuth
                                },
                                appConfigRepository = appConfigRepository,
                                walletCreatorFactory = RealWalletCreatorFactory(
                                  lazyRealWebViewWalletCreator = lazyWalletCreator,
                                  lazyWalletApiWalletCreator = lazy {
                                    RealWalletApiWalletCreator(
                                      walletApiRepository = RealWalletApiRepository(
                                        ktorWrapper = ktorWrapper,
                                        userSignerProvider = {
                                          RealUserSigner(
                                            webViewHandler = webViewHandler,
                                            privyAuth = privyAuth
                                          ).bind()
                                        },
                                        appId = privyAppId,
                                        environment = privyEnvironment,
                                        jsonCanonicalizer = jsonCanonicalizer
                                      ).bind(),
                                      privyLogger = privyLogger
                                    ).bind()
                                  }
                                ).bind(),
                                embeddedWalletRepository = embeddedWalletRepository
                              ).bind()
                            },
                            privyLogger = privyLogger
                          ).bind()
                        }
                      ).bind()
                    }
                  ).bind(),
                  embeddedSolanaWalletFactory = RealEmbeddedSolanaWalletFactory(
                    embeddedSolanaWalletCreator = { arg0_ ->
                      RealEmbeddedSolanaWallet(
                        embeddedWalletDetails = arg0_,
                        rpcProviderCreator = { arg0__ ->
                          RealEmbeddedSolanaWalletProvider(
                            embeddedWalletDetails = arg0__,
                            embeddedWalletManager =
                                _scoped.get("io.privy.wallet.EmbeddedWalletManager") {
                              RealEmbeddedWalletManager(
                                privyLogger = privyLogger,
                                internalAuthStateRepository = internalAuthStateRepository,
                                webViewWalletConnector = webViewWalletConnector,
                                rpcExecutorFactory = RealWalletRpcExecutorFactory(
                                  lazyWebViewWalletRPCExecutor = lazyWalletRpcExecutor,
                                  lazyWalletApiRPCExecutor = lazy {
                                    RealWalletApiRpcExecutor(
                                      walletApi = RealWalletApiRepository(
                                        ktorWrapper = ktorWrapper,
                                        userSignerProvider = {
                                          RealUserSigner(
                                            webViewHandler = webViewHandler,
                                            privyAuth = privyAuth
                                          ).bind()
                                        },
                                        appId = privyAppId,
                                        environment = privyEnvironment,
                                        jsonCanonicalizer = jsonCanonicalizer
                                      ).bind()
                                    ).bind()
                                  }
                                ).bind(),
                                lazyPrivyAuth = lazy {
                                  privyAuth
                                },
                                appConfigRepository = appConfigRepository,
                                walletCreatorFactory = RealWalletCreatorFactory(
                                  lazyRealWebViewWalletCreator = lazyWalletCreator,
                                  lazyWalletApiWalletCreator = lazy {
                                    RealWalletApiWalletCreator(
                                      walletApiRepository = RealWalletApiRepository(
                                        ktorWrapper = ktorWrapper,
                                        userSignerProvider = {
                                          RealUserSigner(
                                            webViewHandler = webViewHandler,
                                            privyAuth = privyAuth
                                          ).bind()
                                        },
                                        appId = privyAppId,
                                        environment = privyEnvironment,
                                        jsonCanonicalizer = jsonCanonicalizer
                                      ).bind(),
                                      privyLogger = privyLogger
                                    ).bind()
                                  }
                                ).bind(),
                                embeddedWalletRepository = embeddedWalletRepository
                              ).bind()
                            },
                            privyLogger = privyLogger
                          ).bind()
                        }
                      ).bind()
                    }
                  ).bind(),
                  embeddedWalletManager = _scoped.get("io.privy.wallet.EmbeddedWalletManager") {
                    RealEmbeddedWalletManager(
                      privyLogger = privyLogger,
                      internalAuthStateRepository = internalAuthStateRepository,
                      webViewWalletConnector = webViewWalletConnector,
                      rpcExecutorFactory = RealWalletRpcExecutorFactory(
                        lazyWebViewWalletRPCExecutor = lazyWalletRpcExecutor,
                        lazyWalletApiRPCExecutor = lazy {
                          RealWalletApiRpcExecutor(
                            walletApi = RealWalletApiRepository(
                              ktorWrapper = ktorWrapper,
                              userSignerProvider = {
                                RealUserSigner(
                                  webViewHandler = webViewHandler,
                                  privyAuth = privyAuth
                                ).bind()
                              },
                              appId = privyAppId,
                              environment = privyEnvironment,
                              jsonCanonicalizer = jsonCanonicalizer
                            ).bind()
                          ).bind()
                        }
                      ).bind(),
                      lazyPrivyAuth = lazy {
                        privyAuth
                      },
                      appConfigRepository = appConfigRepository,
                      walletCreatorFactory = RealWalletCreatorFactory(
                        lazyRealWebViewWalletCreator = lazyWalletCreator,
                        lazyWalletApiWalletCreator = lazy {
                          RealWalletApiWalletCreator(
                            walletApiRepository = RealWalletApiRepository(
                              ktorWrapper = ktorWrapper,
                              userSignerProvider = {
                                RealUserSigner(
                                  webViewHandler = webViewHandler,
                                  privyAuth = privyAuth
                                ).bind()
                              },
                              appId = privyAppId,
                              environment = privyEnvironment,
                              jsonCanonicalizer = jsonCanonicalizer
                            ).bind(),
                            privyLogger = privyLogger
                          ).bind()
                        }
                      ).bind(),
                      embeddedWalletRepository = embeddedWalletRepository
                    ).bind()
                  },
                  privyLogger = privyLogger
                ).bind()
              }
            ).bind()
          },
          logger = privyLogger
        ).bind()
      ).bind().also {
        privyAuth = it
      }
    }

  override val privyLogger: PrivyLogger
    get() = RealPrivyLogger(
      level = privyLogLevel,
      appId = privyAppId
    ).bind()

  override val analyticsManager: AnalyticsManager
    get() = _scoped.get("io.privy.analytics.AnalyticsManager") {
      RealAnalyticsManager(
        analyticsRepository = RealAnalyticsRepository(
          ktorWrapper = ktorWrapper,
          privyLogger = privyLogger,
          clientAnalyticsIdRepository = clientAnalyticsIdRepository
        ).bind()
      ).bind()
    }

  override val clientAnalyticsIdRepository: ClientAnalyticsIdRepository
    get() = _scoped.get("io.privy.analytics.ClientAnalyticsIdRepository") {
      RealClientAnalyticsIdRepository(
        clientAnalyticsIdDataStore =
            _scoped.get("io.privy.analytics.persistence.RealClientAnalyticsIdDataStore") {
          RealClientAnalyticsIdDataStore(
            clientAnalyticsIdDataStoreHolder =
                _scoped.get("io.privy.analytics.persistence.ClientAnalyticsIdDataStoreHolder") {
              provideClientAnalyticsIdDataStore(
                context = context
              )
            }
          )
        }.bind()
      ).bind()
    }
}
