package io.privy.wallet.ethereum

import io.privy.wallet.ChainType
import io.privy.wallet.EmbeddedWalletDetails
import me.tatarka.inject.annotations.Assisted
import me.tatarka.inject.annotations.Inject

@Inject
public class RealEmbeddedEthereumWallet(
    @Assisted embeddedWalletDetails: EmbeddedWalletDetails,
    // Kotlin inject factory for RealRpcProvider
    embeddedEthereumWalletProviderCreator:
        (embeddedWalletDetails: EmbeddedWalletDetails) -> EmbeddedEthereumWalletProvider
) : EmbeddedEthereumWallet {
  override val address: String = embeddedWalletDetails.address
  override val chainId: String? = embeddedWalletDetails.chainId
  override val recoveryMethod: String? = embeddedWalletDetails.recoveryMethod
  override val hdWalletIndex: Int = embeddedWalletDetails.hdWalletIndex
  override val chainType: ChainType = ChainType.Ethereum

  override val provider: EmbeddedEthereumWalletProvider =
      embeddedEthereumWalletProviderCreator(embeddedWalletDetails)
}
