package io.privy.wallet.solana

import io.privy.logging.PrivyLogger
import io.privy.wallet.EmbeddedWalletDetails
import io.privy.wallet.EmbeddedWalletManager
import me.tatarka.inject.annotations.Assisted
import me.tatarka.inject.annotations.Inject

@Inject
public class RealEmbeddedSolanaWalletProvider(
    @Assisted private val embeddedWalletDetails: EmbeddedWalletDetails,
    private val embeddedWalletManager: EmbeddedWalletManager,
    private val privyLogger: PrivyLogger,
) : EmbeddedSolanaWalletProvider {
  override suspend fun signMessage(message: String): Result<String> {
    privyLogger.internal("Solana sign message request! message: ${message}")

    return embeddedWalletManager
        .solanaRpc(
            embeddedWalletDetails = embeddedWalletDetails,
            request = SolanaRpcRequest.SignMessageParams(message = message))
        .map { it.signature }
  }
}
