package io.privy.wallet.solana

import io.privy.wallet.ChainType
import io.privy.wallet.EmbeddedWalletDetails
import me.tatarka.inject.annotations.Assisted
import me.tatarka.inject.annotations.Inject

@Inject
public class RealEmbeddedSolanaWallet(
    @Assisted embeddedWalletDetails: EmbeddedWalletDetails,
    // Kotlin inject factory for RealEmbeddedSolanaWalletProvider
    rpcProviderCreator:
        (embeddedWalletDetails: EmbeddedWalletDetails) -> EmbeddedSolanaWalletProvider
) : EmbeddedSolanaWallet {
  override val address: String = embeddedWalletDetails.address
  override val chainId: String? = embeddedWalletDetails.chainId
  override val recoveryMethod: String? = embeddedWalletDetails.recoveryMethod
  override val hdWalletIndex: Int = embeddedWalletDetails.hdWalletIndex
  override val chainType: ChainType = ChainType.Solana

  override val provider: EmbeddedSolanaWalletProvider = rpcProviderCreator(embeddedWalletDetails)
}
