package io.privy.wallet.walletApi.rpc.solana

import kotlinx.serialization.Required
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

/**
 * Parameters for Solana signMessage method.
 */
@Serializable
public data class WalletApiSolanaSignMessageRpcParams(
    /** Message to sign with the wallet. Must be base64 encoded. */
    val message: String,
    /** Encoding scheme for the message. For Solana signMessage, this is typically "base64". */
    @Required
    val encoding: MessageEncoding = MessageEncoding.BASE64
) {
    /**
     * Encoding scheme for messages for Solana signMessage.
     */
    @Serializable
    public enum class MessageEncoding {
        @SerialName("base64")
        BASE64;
    }
}

/**
 * Solana signMessage response details.
 */
@Serializable
public data class WalletApiSolanaSignMessageRpcResponse(
    /** Signature produced by the wallet, base64 encoded. */
    val signature: String
)