/*
 * Decompiled with CFR 0.152.
 */
package io.privy.wallet.walletApi.rpc.ethereum;

import io.privy.wallet.walletApi.rpc.ethereum.WalletApiCAIP2Serializer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable(with=WalletApiCAIP2Serializer.class)
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0019\b\u0012\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\bJ\b\u0010\f\u001a\u00020\u0003H\u0016J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0007\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\n\u00a8\u0006\u0013"}, d2={"Lio/privy/wallet/walletApi/rpc/ethereum/WalletApiCAIP2;", "", "caip2String", "", "<init>", "(Ljava/lang/String;)V", "namespace", "reference", "(Ljava/lang/String;Ljava/lang/String;)V", "getNamespace", "()Ljava/lang/String;", "getReference", "toString", "equals", "", "other", "hashCode", "", "Companion", "impl_release"})
public final class WalletApiCAIP2 {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String caip2String;
    @NotNull
    private static final Regex CAIP2_REGEX = new Regex("^[-a-z0-9]{3,8}:[-_a-zA-Z0-9]{1,32}$");

    public WalletApiCAIP2(@NotNull String caip2String) {
        Intrinsics.checkNotNullParameter((Object)caip2String, (String)"caip2String");
        this.caip2String = caip2String;
    }

    private WalletApiCAIP2(String namespace, String reference) {
        this(namespace + ":" + reference);
    }

    @NotNull
    public final String getNamespace() {
        String[] stringArray = new String[]{":"};
        return (String)StringsKt.split$default((CharSequence)this.caip2String, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(0);
    }

    @NotNull
    public final String getReference() {
        String[] stringArray = new String[]{":"};
        return (String)StringsKt.split$default((CharSequence)this.caip2String, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(1);
    }

    @NotNull
    public String toString() {
        return this.caip2String;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof WalletApiCAIP2)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.caip2String, (Object)((WalletApiCAIP2)other).caip2String);
    }

    public int hashCode() {
        return this.caip2String.hashCode();
    }

    public /* synthetic */ WalletApiCAIP2(String namespace, String reference, DefaultConstructorMarker $constructor_marker) {
        this(namespace, reference);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fJ\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/privy/wallet/walletApi/rpc/ethereum/WalletApiCAIP2$Companion;", "", "<init>", "()V", "CAIP2_REGEX", "Lkotlin/text/Regex;", "fromString", "Lio/privy/wallet/walletApi/rpc/ethereum/WalletApiCAIP2;", "string", "", "forEip155Chain", "chainId", "", "serializer", "Lkotlinx/serialization/KSerializer;", "impl_release"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final WalletApiCAIP2 fromString(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            return CAIP2_REGEX.matches((CharSequence)string) ? new WalletApiCAIP2(string) : null;
        }

        @NotNull
        public final WalletApiCAIP2 forEip155Chain(int chainId) {
            return new WalletApiCAIP2("eip155", String.valueOf(chainId), null);
        }

        @NotNull
        public final KSerializer<WalletApiCAIP2> serializer() {
            return WalletApiCAIP2Serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

