package io.privy.wallet

import io.privy.di.KmpAppScope
import io.privy.di.Named
import io.privy.wallet.creation.RealWalletCreatorFactory
import io.privy.wallet.creation.WalletCreator
import io.privy.wallet.creation.WalletCreatorFactory
import io.privy.wallet.creation.RealWalletApiWalletCreator
import io.privy.wallet.creation.RealWebViewWalletCreator
import io.privy.wallet.ethereum.EmbeddedEthereumWalletBindings
import io.privy.wallet.rpc.RealWalletRpcExecutorFactory
import io.privy.wallet.rpc.WalletRpcExecutor
import io.privy.wallet.rpc.WalletRpcExecutorFactory
import io.privy.wallet.solana.EmbeddedSolanaWalletBindings
import io.privy.wallet.walletApi.RealJsonCanonicalizer
import io.privy.wallet.webview.RealUserSigner
import io.privy.wallet.walletApi.RealWalletApiRepository
import io.privy.wallet.walletApi.WalletApiRepository
import io.privy.wallet.walletApi.JsonCanonicalizer
import io.privy.wallet.rpc.RealWalletApiRpcExecutor
import io.privy.wallet.webview.RealWebViewWalletConnector
import io.privy.wallet.webview.RealWebViewWalletRpcExecutor
import io.privy.wallet.webview.UserSigner
import io.privy.wallet.webview.WebViewWalletConnector
import me.tatarka.inject.annotations.Provides

public interface EmbeddedWalletBindings :
    EmbeddedEthereumWalletBindings, EmbeddedSolanaWalletBindings {
  @KmpAppScope @Provides public fun RealEmbeddedWalletManager.bind(): EmbeddedWalletManager = this

  @Provides public fun RealUserSigner.bind(): UserSigner = this
  
  @Provides public fun RealWalletApiRepository.bind(): WalletApiRepository = this
  
  @Provides public fun RealJsonCanonicalizer.bind(): JsonCanonicalizer = this

  // Wallet creation
  @Provides public fun RealWalletCreatorFactory.bind(): WalletCreatorFactory = this

  @Provides public fun RealWebViewWalletCreator.bind(): @Named(RealWebViewWalletCreator.diQualifierName) WalletCreator = this

  @Provides public fun RealWalletApiWalletCreator.bind(): @Named(RealWalletApiWalletCreator.diQualifierName) WalletCreator = this

  // RPC Executors
  @Provides public fun RealWalletRpcExecutorFactory.bind(): WalletRpcExecutorFactory = this

  @Provides public fun RealWebViewWalletRpcExecutor.bind(): @Named(RealWebViewWalletRpcExecutor.diQualifierName) WalletRpcExecutor = this

  @Provides public fun RealWalletApiRpcExecutor.bind(): @Named(RealWalletApiRpcExecutor.diQualifierName) WalletRpcExecutor = this

  // Wallet connector
  @KmpAppScope @Provides public fun RealWebViewWalletConnector.bind(): WebViewWalletConnector = this
}
