package io.privy.wallet.creation

import io.privy.appconfig.EmbeddedWalletConfig
import io.privy.appconfig.EmbeddedWalletMode
import io.privy.di.Named
import me.tatarka.inject.annotations.Inject

@Inject
public class RealWalletCreatorFactory(
  @Named(RealWebViewWalletCreator.diQualifierName) private val lazyRealWebViewWalletCreator: Lazy<WalletCreator>,
  @Named(RealWalletApiWalletCreator.diQualifierName) private val lazyWalletApiWalletCreator: Lazy<WalletCreator>,
): WalletCreatorFactory {
  override suspend fun create(embeddedWalletConfig: EmbeddedWalletConfig): WalletCreator {
    return when(embeddedWalletConfig.mode) {
      // Legacy wallets user webview to create wallets
      EmbeddedWalletMode.LegacyEmbeddedWalletsOnly -> lazyRealWebViewWalletCreator.value
      // server controlled wallets use wallet api to create wallets
      EmbeddedWalletMode.UserControlledServerWalletsOnly -> lazyWalletApiWalletCreator.value
    }
  }
}