package io.privy.wallet.rpc

import io.privy.wallet.EmbeddedWalletDetails
import io.privy.wallet.ethereum.EthereumRpcRequest
import io.privy.wallet.ethereum.EthereumRpcResponse
import io.privy.wallet.solana.SolanaRpcRequest // Changed from rpc.SolanaSignMessageParams
import io.privy.wallet.solana.SolanaSignMessageResponse

/**
 * A strategy for running an RPC on an embedded wallet.
 * The interface can be used to run an RPC request without referencing the specifics on how the request is performed.
 */
public interface WalletRpcExecutor {
    /**
     * Process Ethereum RPC requests
     * 
     * @param request The Ethereum RPC request to process
     * @param embeddedWalletDetails Details about the wallet making the request
     * @param accessToken Authentication token for API access
     * @return Result containing EthereumRpcResponse or failure
     */
    public suspend fun performEthRpc(
        request: EthereumRpcRequest,
        embeddedWalletDetails: EmbeddedWalletDetails,
        accessToken: String
    ): Result<EthereumRpcResponse>
    
    /**
     * Process Solana RPC requests
     * 
     * @param request The Solana sign message parameters
     * @param embeddedWalletDetails Details about the wallet making the request
     * @param accessToken Authentication token for API access
     * @return Result containing SolanaSignMessageResponse or failure
     */
    public suspend fun performSolanaRpc(
        request: SolanaRpcRequest, // Changed from SolanaSignMessageParams
        embeddedWalletDetails: EmbeddedWalletDetails,
        accessToken: String
    ): Result<SolanaSignMessageResponse>
}