package io.privy.wallet.walletApi

import io.privy.wallet.walletApi.create.WalletApiCreateRequest
import io.privy.wallet.walletApi.create.WalletApiCreateResponse
import io.privy.wallet.walletApi.rpc.WalletApiRpcRequest
import io.privy.wallet.walletApi.rpc.WalletApiRpcResponse

/**
 * Repository for interacting with the Wallets API
 */
public interface WalletApiRepository {
    /**
     * Creates a new wallet
     *
     * @param request The request parameters for creating a wallet
     * @param token The access token for authentication
     * @return The created wallet response
     * @throws Exception if the request fails
     */
    public suspend fun createWallet(
        request: WalletApiCreateRequest, 
        token: String
    ): Result<WalletApiCreateResponse>
    
    /**
     * Performs an RPC operation on a wallet
     *
     * @param request The RPC request
     * @param walletId The ID of the wallet to perform the operation on
     * @param token The access token for authentication
     * @return The RPC response
     * @throws Exception if the request fails
     */
    public suspend fun rpc(
        request: WalletApiRpcRequest,
        walletId: String,
        token: String
    ): Result<WalletApiRpcResponse>
}
