package io.privy.wallet.walletApi.rpc.ethereum

import kotlinx.serialization.Serializable

/**
 * Ethereum secp256k1_sign RPC parameters
 */
@Serializable
public data class WalletApiEthereumSecp256k1SignRpcParams(
    /**
     * The bytes to sign with the wallet. Must be a hex encoding (0x...)
     */
    val hash: String
)

/**
 * Ethereum secp256k1_sign RPC response
 */
@Serializable
public data class WalletApiEthereumSecp256k1SignRpcResponse(
    /**
     * Signature produced by the wallet
     */
    val signature: String
)