package io.privy.wallet.walletApi.rpc.ethereum

import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

/**
 * Represents an unsigned Ethereum transaction for the Wallet API.
 * This structure is used for sending transaction details to the backend.
 */
@Serializable
public data class WalletApiUnsignedEthereumTransaction(
    /** The address the transaction is sent from. Must be hexadecimal formatted. */
    val from: String? = null,

    /** Destination address of the transaction. */
    val to: String? = null,

    /** (optional) The nonce to be used for the transaction (hexadecimal or number). */
    val nonce: String? = null,

    /** (optional) The max units of gas that can be used by this transaction (hexadecimal or number). */
    @SerialName("gas_limit")
    val gasLimit: String? = null,

    /** (optional) The price (in wei) per unit of gas for this transaction (hexadecimal or number),
     * for use in non EIP-1559 transactions (type 0 or 1). */
    @SerialName("gas_price")
    val gasPrice: String? = null,

    /** Data to send to the receiving address, especially when calling smart contracts. Must be hexadecimal formatted. */
    val data: String? = null,

    /** (optional) The value (in wei) be sent with the transaction (hexadecimal or number). */
    val value: String? = null,

    /** The chain ID of network your transaction will be sent on (number). */
    @SerialName("chain_id")
    val chainId: Int? = null,

    /** (optional) The EIP-2718 transaction type (e.g. `2` for EIP-1559 transactions). */
    val type: Int? = null,

    /** (optional) The maxFeePerGas (hexadecimal or number) to be used in this transaction,
     * for use in EIP-1559 (type 2) transactions. */
    @SerialName("max_fee_per_gas")
    val maxFeePerGas: String? = null,

    /** (optional) The maxPriorityFeePerGas (hexadecimal or number) to be used in this transaction,
     * for use in EIP-1559 (type 2) transactions. */
    @SerialName("max_priority_fee_per_gas")
    val maxPriorityFeePerGas: String? = null
)
