package io.privy.wallet.webview

import io.privy.auth.AuthManager
import me.tatarka.inject.annotations.Inject

/**
 * Implementation of [UserSigner] that uses the webview iframe for signing.
 */
@Inject
public class RealUserSigner(
    private val webViewHandler: WebViewHandler,
    private val authManager: AuthManager
) : UserSigner {

    override suspend fun signature(message: ByteArray): Result<ByteArray> {
        // The ensureAuthenticated method takes a lambda that processes the session and returns a Result
        return authManager.ensureAuthenticated { session ->
            // Get access token from the session
            val accessToken = session.accessToken

            // Send the signing request to the webview handler
            val response = webViewHandler.signWithUserSigner(accessToken = accessToken, message = message)

            // Convert the IFrameResponse to a Result
            when (response) {
                is IFrameResponse.Success -> Result.success(response.value.data.signature)
                is IFrameResponse.Error -> Result.failure(Exception("Failed to sign message: ${response.message}"))
            }
        }
    }
}