/*
 * Decompiled with CFR 0.152.
 */
package io.privy.wallet.walletApi.rpc.ethereum;

import io.privy.wallet.walletApi.rpc.ethereum.QuantitySerializer;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable(with=QuantitySerializer.class)
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\b\u0007\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\b\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\r"}, d2={"Lio/privy/wallet/walletApi/rpc/ethereum/Quantity;", "", "hexString", "", "<init>", "(Ljava/lang/String;)V", "getHexString", "()Ljava/lang/String;", "number", "", "getNumber", "()Ljava/lang/Integer;", "Companion", "impl_release"})
public final class Quantity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String hexString;

    public Quantity(@NotNull String hexString) {
        Intrinsics.checkNotNullParameter((Object)hexString, (String)"hexString");
        this.hexString = hexString;
    }

    @NotNull
    public final String getHexString() {
        return this.hexString;
    }

    @Nullable
    public final Integer getNumber() {
        Integer n;
        if (StringsKt.startsWith$default((String)this.hexString, (String)"0x", (boolean)false, (int)2, null)) {
            String string = this.hexString.substring(2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            n = StringsKt.toIntOrNull((String)string, (int)16);
        } else {
            n = StringsKt.toIntOrNull((String)this.hexString, (int)16);
        }
        return n;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a8\u0006\n"}, d2={"Lio/privy/wallet/walletApi/rpc/ethereum/Quantity$Companion;", "", "<init>", "()V", "fromNumber", "Lio/privy/wallet/walletApi/rpc/ethereum/Quantity;", "number", "", "serializer", "Lkotlinx/serialization/KSerializer;", "impl_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Quantity fromNumber(int number) {
            String string = Integer.toString(number, CharsKt.checkRadix((int)16));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String string2 = string.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
            return new Quantity("0x" + string2);
        }

        @NotNull
        public final KSerializer<Quantity> serializer() {
            return QuantitySerializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

