package io.privy.wallet.creation

import io.privy.logging.PrivyLogger
import io.privy.wallet.ChainType
import io.privy.wallet.EmbeddedWalletDetails
import io.privy.wallet.walletApi.WalletApiRepository
import io.privy.wallet.walletApi.create.WalletApiCreateRequest
import me.tatarka.inject.annotations.Inject

@Inject
public class RealWalletApiWalletCreator(
  private val walletApiRepository: WalletApiRepository,
  private val privyLogger: PrivyLogger,
): WalletCreator {
  public companion object {
    public const val diQualifierName: String = "WalletApiWalletCreator"
  }

  override suspend fun createEthereumWallet(
    accessToken: String,
    existingSolanaWalletAddress: String?
  ): Result<String> {
    return walletApiRepository.createWallet(
      request = WalletApiCreateRequest(chainType = ChainType.Ethereum),
      token = accessToken,
    ).map {
      it.address
    }
    .onSuccess {
      privyLogger.debug("Wallet API: Successfully created Ethereum wallet with address: $it.")
    }
  }

  override suspend fun createAdditionalEthereumWallet(
    accessToken: String,
    hdWalletIndex: Int,
    entropyWalletDetails: EmbeddedWalletDetails.EntropyWalletDetails
  ): Result<String> {
    return walletApiRepository.createWallet(
      request = WalletApiCreateRequest(chainType = ChainType.Ethereum),
      token = accessToken,
    ).map {
      it.address
    }
      .onSuccess {
        privyLogger.debug("Wallet API: Successfully created Ethereum wallet with address: $it.")
      }
  }

  override suspend fun createAdditionalSolanaWallet(
    accessToken: String,
    hdWalletIndex: Int,
    entropyWalletDetails: EmbeddedWalletDetails.EntropyWalletDetails
  ): Result<String> {
    return walletApiRepository.createWallet(
      request = WalletApiCreateRequest(chainType = ChainType.Solana),
      token = accessToken,
    ).map {
      it.address
    }
      .onSuccess {
        privyLogger.debug("Wallet API: Successfully created Solana wallet with address: $it.")
      }
  }

  override suspend fun createSolanaWallet(
    accessToken: String,
    existingEthereumWalletAddress: String?
  ): Result<String> {
    return walletApiRepository.createWallet(
      request = WalletApiCreateRequest(chainType = ChainType.Solana),
      token = accessToken,
    ).map {
      it.address
    }
    .onSuccess {
      privyLogger.debug("Wallet API: Successfully created Solana wallet with address: $it.")
    }
  }

}