package io.privy.wallet.walletApi

import kotlinx.serialization.KSerializer

/**
 * Interface for canonicalizing JSON objects according to RFC8785.
 *
 * Canonical JSON is required for consistent cryptographic signing across platforms.
 */
public interface JsonCanonicalizer {
    /**
     * Encodes a serializable value into a canonical JSON ByteArray using an explicit serializer.
     *
     * @param T The type of the value to encode.
     * @param serializer The KSerializer<T> for the type T.
     * @param value The value to encode.
     * @return A Result<ByteArray> containing the canonical JSON representation encoded in UTF-8.
     */
    public fun <T> encode(serializer: KSerializer<T>, value: T): Result<ByteArray>
}
