package io.privy.wallet.walletApi.rpc.ethereum

import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

/**
 * Parameters for Ethereum personal_sign method.
 */
@Serializable
public data class WalletApiEthereumPersonalSignRpcParams(
    /** Message to sign with the wallet. Must be encoded per the scheme in `encoding`. */
    val message: String,
    /** Encoding scheme for the message. */
    val encoding: MessageEncoding
) {
    /**
     * Encoding scheme for messages for Ethereum personal_sign.
     */
    @Serializable
    public enum class MessageEncoding {
        /** Used for plaintext message signatures. */
        @SerialName("utf-8")
        UTF8,

        /** Used for signing raw bytes. */
        @SerialName("hex")
        HEX;
    }
}

/**
 * Ethereum personal_sign response details.
 */
@Serializable
public data class WalletApiEthereumPersonalSignRpcResponse(
    /** Signature produced by the wallet. */
    val signature: String
)