package io.privy.wallet.walletApi.rpc.ethereum

import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

// eth_sendTransaction ethereum RPC

/**
 * Parameters for the Ethereum send transaction RPC request.
 */
@Serializable
public data class WalletApiEthereumSendTransactionRpcParams(
    /**
     * The transaction to be signed with the wallet and broadcast.
     */
    val transaction: WalletApiUnsignedEthereumTransaction
)

/**
 * Response from the Ethereum send transaction RPC request.
 */
@Serializable
public data class WalletApiEthereumSendTransactionRpcResponseData(
    /**
     * A Privy-assigned id for the sent transaction.
     */
    @SerialName("transaction_id")
    val transactionId: String,
    
    /**
     * Blockchain hash of the sent transaction.
     */
    val hash: String,
    
    /**
     * The CAIP-2 chain id the transaction was sent on.
     */
    val caip2: WalletApiCAIP2
)
