package io.privy.wallet.walletApi.rpc.ethereum

import kotlinx.serialization.Serializable
import kotlinx.serialization.json.JsonElement
import kotlinx.serialization.SerialName

/**
 * Parameters for eth_signTypedDataV4 ethereum RPC
 */
@Serializable
public data class WalletApiEthereumSignTypedDataV4RpcParams(
    /**
     * The typed data to sign
     */
    @SerialName("typed_data")
    public val typedData: EthereumTypedDataV4
)

/**
 * EIP-712 typed data for Ethereum signing
 */
@Serializable
public data class EthereumTypedDataV4(
    /**
     * Domain data for the typed data
     */
    public val domain: JsonElement,

    /**
     * Types information for the typed data
     */
    public val types: Map<String, List<DomainType>>,

    /**
     * Message data for the typed data
     */
    public val message: JsonElement,

    /**
     * Primary type for the typed data. This will be mapped from/to "primary_type"
     * in JSON for backend compatibility.
     */
    @SerialName("primary_type")
    public val primaryType: String
) {
    /**
     * Domain type description for EIP-712 typed data
     */
    @Serializable
    public data class DomainType(
        /**
         * Name of the domain field
         */
        public val name: String,

        /**
         * Type of the domain field
         */
        public val type: String
    )
}

/**
 * Response from eth_signTypedDataV4 ethereum RPC
 */
@Serializable
public data class WalletApiEthereumSignTypedDataV4RpcResponse(
    /**
     * Signature produced by the wallet
     */
    public val signature: String
)
