package io.privy.wallet.webview


/**
 * Interface for signing messages with a user's signer key.
 */
public interface UserSigner {
    /**
     * Signs a byte sequence with the user's signer key.
     *
     * @param message The message to sign as a ByteArray
     * @return The signature of the message, also as a ByteArray
     * @throws Exception if authenticating the user is unsuccessful
     */
    public suspend fun signature(message: ByteArray): Result<ByteArray>
}


