package io.privy.wallet.walletApi.rpc.ethereum

import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

// eth_signTransaction ethereum RPC

@Serializable
public data class WalletApiEthereumSignTransactionRpcParams(
    /**
     * The transaction to sign with the wallet.
     * This should refer to the WalletApiUnsignedEthereumTransaction defined in its own file.
     */
    val transaction: WalletApiUnsignedEthereumTransaction
)

@Serializable
public data class WalletApiEthereumSignTransactionRpcResponseData(
    /**
     * Signature produced by the wallet
     */
    @SerialName("signed_transaction")
    val signedTransaction: String
)
