package io.privy.wallet.rpc

import io.privy.di.Named
import io.privy.wallet.EmbeddedWalletDetails
import io.privy.wallet.PrivyStack
import io.privy.wallet.webview.RealWebViewWalletRpcExecutor
import me.tatarka.inject.annotations.Inject

public interface WalletRpcExecutorFactory {
  public suspend fun create(embeddedWalletDetails: EmbeddedWalletDetails): WalletRpcExecutor
}

@Inject
public class RealWalletRpcExecutorFactory(
  @Named(RealWebViewWalletRpcExecutor.diQualifierName) private val lazyWebViewWalletRPCExecutor: Lazy<WalletRpcExecutor>,
  @Named(RealWalletApiRpcExecutor.diQualifierName) private val lazyWalletApiRPCExecutor: Lazy<WalletRpcExecutor>,
): WalletRpcExecutorFactory {
  override suspend fun create(embeddedWalletDetails: EmbeddedWalletDetails): WalletRpcExecutor {
    return when(embeddedWalletDetails.privyStack) {
      // Legacy stack uses webview
      PrivyStack.Legacy -> lazyWebViewWalletRPCExecutor.value
      // Unified stack uses wallet API
      PrivyStack.Unified -> lazyWalletApiRPCExecutor.value
    }
  }
}