package io.privy.wallet

public data class EmbeddedWalletDetails(
  val address: String,
  val chainId: String?,
  val recoveryMethod: String?,
  val hdWalletIndex: Int,
  val chainType: String,
  // iFrame events require entropy info of the user's Primary wallet
  // The users primary wallet is either their Ethereum wallet w/ HD index 0, or if they don't have one,
  // it's the user's Solana wallet w/ HD index 0
  val primaryWalletDetails: PrimaryWalletDetails
) {
  public data class PrimaryWalletDetails(
    val address: String,
    val entropyId: String,
    val entropyIdVerifier: String,
  )
}