package io.privy.wallet.webview

import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

/**
 * This class is meant to be used as the model to deserialize error responses received from the
 * webview after injecting javascript.
 */
@Serializable
public data class PrivyIFrameErrorResponse(
    @SerialName("id") val requestId: String,
    val event: PrivyEventType,
    val error: ErrorData
) {
  @Serializable public data class ErrorData(val type: String, val message: String)
}
