package io.privy.wallet.webview

import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

@Serializable
public data class PrivyIFrameRequest<T>(val id: String, val event: PrivyEventType, val data: T?)

@Serializable
public enum class PrivyEventType {
  @SerialName(IFrameReadyEventName) Ready,
  @SerialName(CreateEthereumWalletEventName) CreateEthereumWallet,
  @SerialName(CreateSolanaWalletEventName) CreateSolanaWallet,
  @SerialName(CreateAdditionalWalletEventName) CreateAdditional,
  @SerialName(WalletConnectEventName) Connect,
  @SerialName(WalletRecoverEventName) Recover,
  @SerialName(RpcRequestEventName) Rpc
}

internal const val IFrameReadyEventName = "privy:iframe:ready"
internal const val WalletConnectEventName = "privy:wallets:connect"
internal const val WalletRecoverEventName = "privy:wallets:recover"
internal const val CreateEthereumWalletEventName = "privy:wallet:create"
internal const val CreateSolanaWalletEventName = "privy:solana-wallet:create"
internal const val CreateAdditionalWalletEventName = "privy:wallet:create-additional"
internal const val RpcRequestEventName = "privy:wallets:rpc"
