package io.privy.wallet.creation

public interface WalletCreator {
  /**
   * Creates a new Ethereum embedded wallet for the user
   *
   * @return A result type with the newly created wallet address or a failure
   */
  public suspend fun createEthereumWallet(
    accessToken: String,
    existingSolanaWalletAddress: String?,
  ): Result<String>

  /**
   * Creates a new HD embedded wallet for the user.
   *
   * @return A result type with the newly created wallet address or a failure
   */
  public suspend fun createAdditionalEthereumWallet(
    accessToken: String,
    primaryWalletAddress: String,
    hdWalletIndex: Int,
  ): Result<String>



  public suspend fun createAdditionalSolanaWallet(
    accessToken: String,
    primaryWalletAddress: String,
    hdWalletIndex: Int,
  ): Result<String>


  /**
   * Creates a new Solana embedded wallet for the user
   *
   * @return A result type with the newly created wallet address or a failure
   */
  public suspend fun createSolanaWallet(
    accessToken: String,
    existingEthereumWalletAddress: String?,
  ): Result<String>
}