package io.privy.wallet

public enum class WalletClientType(private val rawValue: String) {
  // To be used if no wallet clients below apply
  Other("other"),

  // Privy wallet
  Privy("privy"),

  // Coinbase wallet
  CoinbaseWallet("coinbase_wallet"),

  // Wallet Connect supported wallets
  Metamask("metamask"),
  Trust("trust"),
  Safe("safe"),
  Rainbow("rainbow"),
  Uniswap("uniswap"),
  Zerion("zerion"),
  Argent("argent"),
  Spot("spot"),
  Omni("omni"),
  Cryptocom("cryptocom"),
  Blockchain("blockchain"),
  Safepal("safepal"),
  Bitkeep("bitkeep"),
  Zengo("zengo"),
  OneInch("oneInch"),
  Binance("binance"),
  Exodus("exodus"),
  MewWallet("mew_wallet"),
  Alphawallet("alphawallet"),
  KeyringPro("keyring_pro"),
  Mathwallet("mathwallet"),
  Unstoppable("unstoppable"),
  Obvious("obvious"),
  Ambire("ambire"),
  InternetMoneyWallet("internet_money_wallet"),
  Coin98("coin98"),
  AbcWallet("abc_wallet"),
  ArculusWallet("arculus_wallet"),
  Haha("haha"),
  ClingWallet("cling_wallet"),
  Broearn("broearn"),
  Copiosa("copiosa"),
  BurritoWallet("burrito_wallet"),
  EnjinWallet("enjin_wallet"),
  PlasmaWallet("plasma_wallet"),
  Avacus("avacus"),
  Bee("bee"),
  Pitaka("pitaka"),
  Pltwallet("pltwallet"),
  Minerva("minerva"),
  Kryptogo("kryptogo"),
  Prema("prema"),
  Slingshot("slingshot"),
  Kriptonio("kriptonio"),
  Timeless("timeless"),
  Secux("secux"),
  Bitizen("bitizen"),
  Blocto("blocto"),
  Safemoon("safemoon");

  // Internal method to access rawValue if needed within the package/module
  override fun toString(): String = rawValue
}
