package io.privy.wallet.ethereum

/**
 * An Ethereum wallet RPC provider, inspired by
 * [EIP-1193 standard](https://eips.ethereum.org/EIPS/eip-1193).
 */
public interface EmbeddedEthereumWalletProvider {
  /**
   * Sends a request to the Ethereum provider.
   *
   * Example usage:
   * ```kotlin
   * ethereumEmbeddedWallet.provider.request(
   *    request = EthereumRpcRequest(
   *      method = "personal_sign",
   *      params = listOf("A message to sign", ethereumEmbeddedWallet.address)
   *    )
   * )
   * ```
   *
   * @param The rpc request
   * @return The response received
   */
  public suspend fun request(request: EthereumRpcRequest): Result<EthereumRpcResponse>
}
