package io.privy.wallet.webview

import io.privy.wallet.EmbeddedWalletDetails
import io.privy.wallet.ethereum.EthereumRpcRequest
import io.privy.wallet.solana.SolanaRpcRequest
import io.privy.wallet.solana.SolanaSignMessageResponse

public interface WebViewHandler {
  public suspend fun createEthereumWallet(
      accessToken: String,
      existingSolanaWalletAddress: String?,
  ): IFrameResponse<PrivyIFrameSuccessResponse.CreateEthereumWalletResponse>

  public suspend fun createAdditionalWallet(
      accessToken: String,
      primaryWalletAddress: String,
      hdWalletIndex: Int,
  ): IFrameResponse<PrivyIFrameSuccessResponse.CreateAdditionalWalletResponse>

  public suspend fun createSolanaWallet(
      accessToken: String,
      existingEthereumWalletAddress: String?,
  ): IFrameResponse<PrivyIFrameSuccessResponse.CreateSolanaWalletResponse>

  public suspend fun connectWallet(
      accessToken: String,
      embeddedWalletDetails: EmbeddedWalletDetails
  ): IFrameResponse<PrivyIFrameSuccessResponse.ConnectWalletResponse>

  public suspend fun recoverWallet(
      accessToken: String,
      embeddedWalletDetails: EmbeddedWalletDetails,
  ): IFrameResponse<PrivyIFrameSuccessResponse.RecoverWalletResponse>

  public suspend fun solanaRpc(
      accessToken: String,
      embeddedWalletDetails: EmbeddedWalletDetails,
      request: SolanaRpcRequest
  ): Result<SolanaSignMessageResponse>

    // TODO: is there a way to make this resuable with solana?
    public suspend fun ethereumRpc(
        accessToken: String,
        embeddedWalletDetails: EmbeddedWalletDetails,
        request: EthereumRpcRequest
    ): IFrameResponse<PrivyIFrameSuccessResponse.WalletRpcResponse<String>>

    public suspend fun signWithUserSigner(
        accessToken: String,
        message: ByteArray
    ): IFrameResponse<PrivyIFrameSuccessResponse.UserSignerSignResponse>
}
