package io.privy.wallet.webview

import kotlinx.serialization.Serializable

@Serializable
public data class UserSignerSignRequestData(
    val accessToken: String,
    @Serializable(with = Base64ByteArraySerializer::class)
    val message: ByteArray
    
) {
    // Overriding equals and hashCode to ensure content-based comparison for ByteArray.
    // Default data class behavior for Arrays is reference equality, which is not desired here.
    override fun equals(other: Any?): Boolean {

        if (this === other) return true
        if (other !is UserSignerSignResponseData) return false
        if (!message.contentEquals(other.signature)) return false
        return true
    }

    override fun hashCode(): Int {
        // Use contentHashCode for array hashing to match the equals behavior.
        return message.contentHashCode()
    }
}
