package io.privy.wallet.solana

public interface EmbeddedSolanaWalletProvider {
  /**
   * Request a signature on a Base64 encoded message or transaction
   *
   * @param message Base64 encoded message or transaction
   * @return The Base64 encoded computed signature
   */
  public suspend fun signMessage(message: String): Result<String>
}